package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HorizontalPodAutoscalerSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHorizontalPodAutoscalerSpecAssert<S extends AbstractHorizontalPodAutoscalerSpecAssert<S, A>, A extends HorizontalPodAutoscalerSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHorizontalPodAutoscalerSpecAssert}</code> to make assertions on actual HorizontalPodAutoscalerSpec.
   * @param actual the HorizontalPodAutoscalerSpec we want to make assertions on.
   */
  protected AbstractHorizontalPodAutoscalerSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual HorizontalPodAutoscalerSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerSpec's cpuUtilization is equal to the given one.
   * @param cpuUtilization the given cpuUtilization to compare the actual HorizontalPodAutoscalerSpec's cpuUtilization to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerSpec's cpuUtilization is not equal to the given one.
   */
  public S hasCpuUtilization(CPUTargetUtilization cpuUtilization) {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cpuUtilization of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CPUTargetUtilization actualCpuUtilization = actual.getCpuUtilization();
    if (!Objects.areEqual(actualCpuUtilization, cpuUtilization)) {
      failWithMessage(assertjErrorMessage, actual, cpuUtilization, actualCpuUtilization);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerSpec's maxReplicas is equal to the given one.
   * @param maxReplicas the given maxReplicas to compare the actual HorizontalPodAutoscalerSpec's maxReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerSpec's maxReplicas is not equal to the given one.
   */
  public S hasMaxReplicas(Integer maxReplicas) {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting maxReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMaxReplicas = actual.getMaxReplicas();
    if (!Objects.areEqual(actualMaxReplicas, maxReplicas)) {
      failWithMessage(assertjErrorMessage, actual, maxReplicas, actualMaxReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerSpec's minReplicas is equal to the given one.
   * @param minReplicas the given minReplicas to compare the actual HorizontalPodAutoscalerSpec's minReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerSpec's minReplicas is not equal to the given one.
   */
  public S hasMinReplicas(Integer minReplicas) {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting minReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMinReplicas = actual.getMinReplicas();
    if (!Objects.areEqual(actualMinReplicas, minReplicas)) {
      failWithMessage(assertjErrorMessage, actual, minReplicas, actualMinReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerSpec's scaleRef is equal to the given one.
   * @param scaleRef the given scaleRef to compare the actual HorizontalPodAutoscalerSpec's scaleRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerSpec's scaleRef is not equal to the given one.
   */
  public S hasScaleRef(SubresourceReference scaleRef) {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting scaleRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SubresourceReference actualScaleRef = actual.getScaleRef();
    if (!Objects.areEqual(actualScaleRef, scaleRef)) {
      failWithMessage(assertjErrorMessage, actual, scaleRef, actualScaleRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
