package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentSpecFluentAssert<S extends AbstractDeploymentSpecFluentAssert<S, A>, A extends DeploymentSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentSpecFluentAssert}</code> to make assertions on actual DeploymentSpecFluent.
   * @param actual the DeploymentSpecFluent we want to make assertions on.
   */
  protected AbstractDeploymentSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpecFluent's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual DeploymentSpecFluent's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpecFluent's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual DeploymentSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpecFluent's selector is equal to the given one.
   * @param selector the given selector to compare the actual DeploymentSpecFluent's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpecFluent's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual DeploymentSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpecFluent's strategy is equal to the given one.
   * @param strategy the given strategy to compare the actual DeploymentSpecFluent's strategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpecFluent's strategy is not equal to the given one.
   */
  public S hasStrategy(DeploymentStrategy strategy) {
    // check that actual DeploymentSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting strategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeploymentStrategy actualStrategy = actual.getStrategy();
    if (!Objects.areEqual(actualStrategy, strategy)) {
      failWithMessage(assertjErrorMessage, actual, strategy, actualStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpecFluent's template is equal to the given one.
   * @param template the given template to compare the actual DeploymentSpecFluent's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpecFluent's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    // check that actual DeploymentSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpecFluent's uniqueLabelKey is equal to the given one.
   * @param uniqueLabelKey the given uniqueLabelKey to compare the actual DeploymentSpecFluent's uniqueLabelKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpecFluent's uniqueLabelKey is not equal to the given one.
   */
  public S hasUniqueLabelKey(String uniqueLabelKey) {
    // check that actual DeploymentSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting uniqueLabelKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUniqueLabelKey = actual.getUniqueLabelKey();
    if (!Objects.areEqual(actualUniqueLabelKey, uniqueLabelKey)) {
      failWithMessage(assertjErrorMessage, actual, uniqueLabelKey, actualUniqueLabelKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
