package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link APIVersion} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAPIVersionAssert<S extends AbstractAPIVersionAssert<S, A>, A extends APIVersion> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAPIVersionAssert}</code> to make assertions on actual APIVersion.
   * @param actual the APIVersion we want to make assertions on.
   */
  protected AbstractAPIVersionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual APIVersion's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual APIVersion's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual APIVersion's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual APIVersion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual APIVersion's apiGroup is equal to the given one.
   * @param apiGroup the given apiGroup to compare the actual APIVersion's apiGroup to.
   * @return this assertion object.
   * @throws AssertionError - if the actual APIVersion's apiGroup is not equal to the given one.
   */
  public S hasApiGroup(String apiGroup) {
    // check that actual APIVersion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiGroup = actual.getApiGroup();
    if (!Objects.areEqual(actualApiGroup, apiGroup)) {
      failWithMessage(assertjErrorMessage, actual, apiGroup, actualApiGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual APIVersion's name is equal to the given one.
   * @param name the given name to compare the actual APIVersion's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual APIVersion's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual APIVersion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
