package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link StatusCauseFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatusCauseFluentImplAssert<S extends AbstractStatusCauseFluentImplAssert<S, A>, A extends StatusCauseFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatusCauseFluentImplAssert}</code> to make assertions on actual StatusCauseFluentImpl.
   * @param actual the StatusCauseFluentImpl we want to make assertions on.
   */
  protected AbstractStatusCauseFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual StatusCauseFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual StatusCauseFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusCauseFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual StatusCauseFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusCauseFluentImpl's field is equal to the given one.
   * @param field the given field to compare the actual StatusCauseFluentImpl's field to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusCauseFluentImpl's field is not equal to the given one.
   */
  public S hasField(String field) {
    // check that actual StatusCauseFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting field of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualField = actual.getField();
    if (!Objects.areEqual(actualField, field)) {
      failWithMessage(assertjErrorMessage, actual, field, actualField);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusCauseFluentImpl's message is equal to the given one.
   * @param message the given message to compare the actual StatusCauseFluentImpl's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusCauseFluentImpl's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual StatusCauseFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusCauseFluentImpl's reason is equal to the given one.
   * @param reason the given reason to compare the actual StatusCauseFluentImpl's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusCauseFluentImpl's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual StatusCauseFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
