package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodTemplateSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateSpecFluentAssert<S extends AbstractPodTemplateSpecFluentAssert<S, A>, A extends PodTemplateSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateSpecFluentAssert}</code> to make assertions on actual PodTemplateSpecFluent.
   * @param actual the PodTemplateSpecFluent we want to make assertions on.
   */
  protected AbstractPodTemplateSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodTemplateSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodTemplateSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodTemplateSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpecFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual PodTemplateSpecFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpecFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual PodTemplateSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpecFluent's spec is equal to the given one.
   * @param spec the given spec to compare the actual PodTemplateSpecFluent's spec to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpecFluent's spec is not equal to the given one.
   */
  public S hasSpec(PodSpec spec) {
    // check that actual PodTemplateSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting spec of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodSpec actualSpec = actual.getSpec();
    if (!Objects.areEqual(actualSpec, spec)) {
      failWithMessage(assertjErrorMessage, actual, spec, actualSpec);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
