package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodSecurityContext} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSecurityContextAssert<S extends AbstractPodSecurityContextAssert<S, A>, A extends PodSecurityContext> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSecurityContextAssert}</code> to make assertions on actual PodSecurityContext.
   * @param actual the PodSecurityContext we want to make assertions on.
   */
  protected AbstractPodSecurityContextAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodSecurityContext's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodSecurityContext's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContext's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContext's fsGroup is equal to the given one.
   * @param fsGroup the given fsGroup to compare the actual PodSecurityContext's fsGroup to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContext's fsGroup is not equal to the given one.
   */
  public S hasFsGroup(Long fsGroup) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualFsGroup = actual.getFsGroup();
    if (!Objects.areEqual(actualFsGroup, fsGroup)) {
      failWithMessage(assertjErrorMessage, actual, fsGroup, actualFsGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContext's runAsNonRoot is equal to the given one.
   * @param runAsNonRoot the given runAsNonRoot to compare the actual PodSecurityContext's runAsNonRoot to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContext's runAsNonRoot is not equal to the given one.
   */
  public S hasRunAsNonRoot(Boolean runAsNonRoot) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsNonRoot of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualRunAsNonRoot = actual.getRunAsNonRoot();
    if (!Objects.areEqual(actualRunAsNonRoot, runAsNonRoot)) {
      failWithMessage(assertjErrorMessage, actual, runAsNonRoot, actualRunAsNonRoot);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContext's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual PodSecurityContext's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContext's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(Long runAsUser) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContext's seLinuxOptions is equal to the given one.
   * @param seLinuxOptions the given seLinuxOptions to compare the actual PodSecurityContext's seLinuxOptions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContext's seLinuxOptions is not equal to the given one.
   */
  public S hasSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting seLinuxOptions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxOptions actualSeLinuxOptions = actual.getSeLinuxOptions();
    if (!Objects.areEqual(actualSeLinuxOptions, seLinuxOptions)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxOptions, actualSeLinuxOptions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContext's supplementalGroups contains the given Long elements.
   * @param supplementalGroups the given elements that should be contained in actual PodSecurityContext's supplementalGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSecurityContext's supplementalGroups does not contain all given Long elements.
   */
  public S hasSupplementalGroups(Long... supplementalGroups) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (supplementalGroups == null) failWithMessage("Expecting supplementalGroups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSupplementalGroups(), supplementalGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContext's supplementalGroups contains <b>only<b> the given Long elements and nothing else in whatever order.
   * @param supplementalGroups the given elements that should be contained in actual PodSecurityContext's supplementalGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSecurityContext's supplementalGroups does not contain all given Long elements.
   */
  public S hasOnlySupplementalGroups(Long... supplementalGroups) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (supplementalGroups == null) failWithMessage("Expecting supplementalGroups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getSupplementalGroups(), supplementalGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContext's supplementalGroups does not contain the given Long elements.
   *
   * @param supplementalGroups the given elements that should not be in actual PodSecurityContext's supplementalGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSecurityContext's supplementalGroups contains any given Long elements.
   */
  public S doesNotHaveSupplementalGroups(Long... supplementalGroups) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (supplementalGroups == null) failWithMessage("Expecting supplementalGroups parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getSupplementalGroups(), supplementalGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContext has no supplementalGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSecurityContext's supplementalGroups is not empty.
   */
  public S hasNoSupplementalGroups() {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have supplementalGroups but had :\n  <%s>";
    
    // check
    if (actual.getSupplementalGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSupplementalGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
