package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PersistentVolumeClaimVolumeSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeClaimVolumeSourceFluentAssert<S extends AbstractPersistentVolumeClaimVolumeSourceFluentAssert<S, A>, A extends PersistentVolumeClaimVolumeSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeClaimVolumeSourceFluentAssert}</code> to make assertions on actual PersistentVolumeClaimVolumeSourceFluent.
   * @param actual the PersistentVolumeClaimVolumeSourceFluent we want to make assertions on.
   */
  protected AbstractPersistentVolumeClaimVolumeSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PersistentVolumeClaimVolumeSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PersistentVolumeClaimVolumeSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimVolumeSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PersistentVolumeClaimVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimVolumeSourceFluent's claimName is equal to the given one.
   * @param claimName the given claimName to compare the actual PersistentVolumeClaimVolumeSourceFluent's claimName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimVolumeSourceFluent's claimName is not equal to the given one.
   */
  public S hasClaimName(String claimName) {
    // check that actual PersistentVolumeClaimVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting claimName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClaimName = actual.getClaimName();
    if (!Objects.areEqual(actualClaimName, claimName)) {
      failWithMessage(assertjErrorMessage, actual, claimName, actualClaimName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
