package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeSystemInfoFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeSystemInfoFluentAssert<S extends AbstractNodeSystemInfoFluentAssert<S, A>, A extends NodeSystemInfoFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeSystemInfoFluentAssert}</code> to make assertions on actual NodeSystemInfoFluent.
   * @param actual the NodeSystemInfoFluent we want to make assertions on.
   */
  protected AbstractNodeSystemInfoFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeSystemInfoFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's bootID is equal to the given one.
   * @param bootID the given bootID to compare the actual NodeSystemInfoFluent's bootID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's bootID is not equal to the given one.
   */
  public S hasBootID(String bootID) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bootID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualBootID = actual.getBootID();
    if (!Objects.areEqual(actualBootID, bootID)) {
      failWithMessage(assertjErrorMessage, actual, bootID, actualBootID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's containerRuntimeVersion is equal to the given one.
   * @param containerRuntimeVersion the given containerRuntimeVersion to compare the actual NodeSystemInfoFluent's containerRuntimeVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's containerRuntimeVersion is not equal to the given one.
   */
  public S hasContainerRuntimeVersion(String containerRuntimeVersion) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting containerRuntimeVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContainerRuntimeVersion = actual.getContainerRuntimeVersion();
    if (!Objects.areEqual(actualContainerRuntimeVersion, containerRuntimeVersion)) {
      failWithMessage(assertjErrorMessage, actual, containerRuntimeVersion, actualContainerRuntimeVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's kernelVersion is equal to the given one.
   * @param kernelVersion the given kernelVersion to compare the actual NodeSystemInfoFluent's kernelVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's kernelVersion is not equal to the given one.
   */
  public S hasKernelVersion(String kernelVersion) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kernelVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKernelVersion = actual.getKernelVersion();
    if (!Objects.areEqual(actualKernelVersion, kernelVersion)) {
      failWithMessage(assertjErrorMessage, actual, kernelVersion, actualKernelVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's kubeProxyVersion is equal to the given one.
   * @param kubeProxyVersion the given kubeProxyVersion to compare the actual NodeSystemInfoFluent's kubeProxyVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's kubeProxyVersion is not equal to the given one.
   */
  public S hasKubeProxyVersion(String kubeProxyVersion) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kubeProxyVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKubeProxyVersion = actual.getKubeProxyVersion();
    if (!Objects.areEqual(actualKubeProxyVersion, kubeProxyVersion)) {
      failWithMessage(assertjErrorMessage, actual, kubeProxyVersion, actualKubeProxyVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's kubeletVersion is equal to the given one.
   * @param kubeletVersion the given kubeletVersion to compare the actual NodeSystemInfoFluent's kubeletVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's kubeletVersion is not equal to the given one.
   */
  public S hasKubeletVersion(String kubeletVersion) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kubeletVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKubeletVersion = actual.getKubeletVersion();
    if (!Objects.areEqual(actualKubeletVersion, kubeletVersion)) {
      failWithMessage(assertjErrorMessage, actual, kubeletVersion, actualKubeletVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's machineID is equal to the given one.
   * @param machineID the given machineID to compare the actual NodeSystemInfoFluent's machineID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's machineID is not equal to the given one.
   */
  public S hasMachineID(String machineID) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting machineID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMachineID = actual.getMachineID();
    if (!Objects.areEqual(actualMachineID, machineID)) {
      failWithMessage(assertjErrorMessage, actual, machineID, actualMachineID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's osImage is equal to the given one.
   * @param osImage the given osImage to compare the actual NodeSystemInfoFluent's osImage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's osImage is not equal to the given one.
   */
  public S hasOsImage(String osImage) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting osImage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualOsImage = actual.getOsImage();
    if (!Objects.areEqual(actualOsImage, osImage)) {
      failWithMessage(assertjErrorMessage, actual, osImage, actualOsImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSystemInfoFluent's systemUUID is equal to the given one.
   * @param systemUUID the given systemUUID to compare the actual NodeSystemInfoFluent's systemUUID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSystemInfoFluent's systemUUID is not equal to the given one.
   */
  public S hasSystemUUID(String systemUUID) {
    // check that actual NodeSystemInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting systemUUID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSystemUUID = actual.getSystemUUID();
    if (!Objects.areEqual(actualSystemUUID, systemUUID)) {
      failWithMessage(assertjErrorMessage, actual, systemUUID, actualSystemUUID);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
