package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EndpointAddressFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointAddressFluentAssert<S extends AbstractEndpointAddressFluentAssert<S, A>, A extends EndpointAddressFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointAddressFluentAssert}</code> to make assertions on actual EndpointAddressFluent.
   * @param actual the EndpointAddressFluent we want to make assertions on.
   */
  protected AbstractEndpointAddressFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EndpointAddressFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EndpointAddressFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EndpointAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointAddressFluent's ip is equal to the given one.
   * @param ip the given ip to compare the actual EndpointAddressFluent's ip to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluent's ip is not equal to the given one.
   */
  public S hasIp(String ip) {
    // check that actual EndpointAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting ip of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualIp = actual.getIp();
    if (!Objects.areEqual(actualIp, ip)) {
      failWithMessage(assertjErrorMessage, actual, ip, actualIp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointAddressFluent's targetRef is equal to the given one.
   * @param targetRef the given targetRef to compare the actual EndpointAddressFluent's targetRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluent's targetRef is not equal to the given one.
   */
  public S hasTargetRef(ObjectReference targetRef) {
    // check that actual EndpointAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectReference actualTargetRef = actual.getTargetRef();
    if (!Objects.areEqual(actualTargetRef, targetRef)) {
      failWithMessage(assertjErrorMessage, actual, targetRef, actualTargetRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
