package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeleteOptionsFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeleteOptionsFluentAssert<S extends AbstractDeleteOptionsFluentAssert<S, A>, A extends DeleteOptionsFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeleteOptionsFluentAssert}</code> to make assertions on actual DeleteOptionsFluent.
   * @param actual the DeleteOptionsFluent we want to make assertions on.
   */
  protected AbstractDeleteOptionsFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeleteOptionsFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeleteOptionsFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeleteOptionsFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeleteOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeleteOptionsFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual DeleteOptionsFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeleteOptionsFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(DeleteOptions.ApiVersion apiVersion) {
    // check that actual DeleteOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeleteOptions.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeleteOptionsFluent's gracePeriodSeconds is equal to the given one.
   * @param gracePeriodSeconds the given gracePeriodSeconds to compare the actual DeleteOptionsFluent's gracePeriodSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeleteOptionsFluent's gracePeriodSeconds is not equal to the given one.
   */
  public S hasGracePeriodSeconds(Long gracePeriodSeconds) {
    // check that actual DeleteOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting gracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGracePeriodSeconds = actual.getGracePeriodSeconds();
    if (!Objects.areEqual(actualGracePeriodSeconds, gracePeriodSeconds)) {
      failWithMessage(assertjErrorMessage, actual, gracePeriodSeconds, actualGracePeriodSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeleteOptionsFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual DeleteOptionsFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeleteOptionsFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual DeleteOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
