/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobSpec;
import io.fabric8.kubernetes.api.model.extensions.JobSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.PodSelector;
import io.fabric8.kubernetes.api.model.extensions.PodSelectorBuilder;
import io.fabric8.kubernetes.api.model.extensions.PodSelectorFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class JobSpecFluentImpl<T extends JobSpecFluent<T>>
extends BaseFluent<T>
implements JobSpecFluent<T> {
    Integer completions;
    Integer parallelism;
    VisitableBuilder<PodSelector, ?> selector;
    VisitableBuilder<PodTemplateSpec, ?> template;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public JobSpecFluentImpl() {
    }

    public JobSpecFluentImpl(JobSpec instance) {
        this.withCompletions(instance.getCompletions());
        this.withParallelism(instance.getParallelism());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public Integer getCompletions() {
        return this.completions;
    }

    @Override
    public T withCompletions(Integer completions) {
        this.completions = completions;
        return (T)this;
    }

    @Override
    public Integer getParallelism() {
        return this.parallelism;
    }

    @Override
    public T withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return (T)this;
    }

    @Override
    public PodSelector getSelector() {
        return this.selector != null ? (PodSelector)this.selector.build() : null;
    }

    @Override
    public T withSelector(PodSelector selector) {
        if (selector != null) {
            this.selector = new PodSelectorBuilder(selector);
            this._visitables.add(this.selector);
        }
        return (T)this;
    }

    @Override
    public JobSpecFluent.SelectorNested<T> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public JobSpecFluent.SelectorNested<T> withNewSelectorLike(PodSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public JobSpecFluent.SelectorNested<T> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    @Override
    public T withTemplate(PodTemplateSpec template) {
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (T)this;
    }

    @Override
    public JobSpecFluent.TemplateNested<T> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public JobSpecFluent.TemplateNested<T> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public JobSpecFluent.TemplateNested<T> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobSpecFluentImpl that = (JobSpecFluentImpl)o;
        if (this.completions != null ? !this.completions.equals(that.completions) : that.completions != null) {
            return false;
        }
        if (this.parallelism != null ? !this.parallelism.equals(that.parallelism) : that.parallelism != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<JobSpecFluent.TemplateNested<N>>
    implements JobSpecFluent.TemplateNested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N endTemplate() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)JobSpecFluentImpl.this.withTemplate(this.builder.build());
        }
    }

    public class SelectorNestedImpl<N>
    extends PodSelectorFluentImpl<JobSpecFluent.SelectorNested<N>>
    implements JobSpecFluent.SelectorNested<N> {
        private final PodSelectorBuilder builder;

        SelectorNestedImpl() {
            this.builder = new PodSelectorBuilder(this);
        }

        SelectorNestedImpl(PodSelector item) {
            this.builder = new PodSelectorBuilder(this, item);
        }

        @Override
        public N endSelector() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)JobSpecFluentImpl.this.withSelector(this.builder.build());
        }
    }
}

