package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentCauseImageTrigger} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentCauseImageTriggerAssert<S extends AbstractDeploymentCauseImageTriggerAssert<S, A>, A extends DeploymentCauseImageTrigger> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentCauseImageTriggerAssert}</code> to make assertions on actual DeploymentCauseImageTrigger.
   * @param actual the DeploymentCauseImageTrigger we want to make assertions on.
   */
  protected AbstractDeploymentCauseImageTriggerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentCauseImageTrigger's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentCauseImageTrigger's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentCauseImageTrigger's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentCauseImageTrigger we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentCauseImageTrigger's from is equal to the given one.
   * @param from the given from to compare the actual DeploymentCauseImageTrigger's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentCauseImageTrigger's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual DeploymentCauseImageTrigger we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
