package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CPUTargetUtilizationFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCPUTargetUtilizationFluentImplAssert<S extends AbstractCPUTargetUtilizationFluentImplAssert<S, A>, A extends CPUTargetUtilizationFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCPUTargetUtilizationFluentImplAssert}</code> to make assertions on actual CPUTargetUtilizationFluentImpl.
   * @param actual the CPUTargetUtilizationFluentImpl we want to make assertions on.
   */
  protected AbstractCPUTargetUtilizationFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CPUTargetUtilizationFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CPUTargetUtilizationFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CPUTargetUtilizationFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CPUTargetUtilizationFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CPUTargetUtilizationFluentImpl's targetPercentage is equal to the given one.
   * @param targetPercentage the given targetPercentage to compare the actual CPUTargetUtilizationFluentImpl's targetPercentage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CPUTargetUtilizationFluentImpl's targetPercentage is not equal to the given one.
   */
  public S hasTargetPercentage(Integer targetPercentage) {
    // check that actual CPUTargetUtilizationFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetPercentage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualTargetPercentage = actual.getTargetPercentage();
    if (!Objects.areEqual(actualTargetPercentage, targetPercentage)) {
      failWithMessage(assertjErrorMessage, actual, targetPercentage, actualTargetPercentage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
