package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PreferencesFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPreferencesFluentImplAssert<S extends AbstractPreferencesFluentImplAssert<S, A>, A extends PreferencesFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPreferencesFluentImplAssert}</code> to make assertions on actual PreferencesFluentImpl.
   * @param actual the PreferencesFluentImpl we want to make assertions on.
   */
  protected AbstractPreferencesFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PreferencesFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PreferencesFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PreferencesFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PreferencesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PreferencesFluentImpl's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual PreferencesFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual PreferencesFluentImpl's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual PreferencesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PreferencesFluentImpl's extensions contains <b>only<b> the given NamedExtension elements and nothing else in whatever order.
   * @param extensions the given elements that should be contained in actual PreferencesFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual PreferencesFluentImpl's extensions does not contain all given NamedExtension elements.
   */
  public S hasOnlyExtensions(NamedExtension... extensions) {
    // check that actual PreferencesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PreferencesFluentImpl's extensions does not contain the given NamedExtension elements.
   *
   * @param extensions the given elements that should not be in actual PreferencesFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual PreferencesFluentImpl's extensions contains any given NamedExtension elements.
   */
  public S doesNotHaveExtensions(NamedExtension... extensions) {
    // check that actual PreferencesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PreferencesFluentImpl has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual PreferencesFluentImpl's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual PreferencesFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
