package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link FlockerVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractFlockerVolumeSourceAssert<S extends AbstractFlockerVolumeSourceAssert<S, A>, A extends FlockerVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractFlockerVolumeSourceAssert}</code> to make assertions on actual FlockerVolumeSource.
   * @param actual the FlockerVolumeSource we want to make assertions on.
   */
  protected AbstractFlockerVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual FlockerVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual FlockerVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FlockerVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual FlockerVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual FlockerVolumeSource's datasetName is equal to the given one.
   * @param datasetName the given datasetName to compare the actual FlockerVolumeSource's datasetName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual FlockerVolumeSource's datasetName is not equal to the given one.
   */
  public S hasDatasetName(String datasetName) {
    // check that actual FlockerVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting datasetName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDatasetName = actual.getDatasetName();
    if (!Objects.areEqual(actualDatasetName, datasetName)) {
      failWithMessage(assertjErrorMessage, actual, datasetName, actualDatasetName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
