package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LifecycleHook} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLifecycleHookAssert<S extends AbstractLifecycleHookAssert<S, A>, A extends LifecycleHook> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLifecycleHookAssert}</code> to make assertions on actual LifecycleHook.
   * @param actual the LifecycleHook we want to make assertions on.
   */
  protected AbstractLifecycleHookAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LifecycleHook's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LifecycleHook's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleHook's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LifecycleHook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleHook's execNewPod is equal to the given one.
   * @param execNewPod the given execNewPod to compare the actual LifecycleHook's execNewPod to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleHook's execNewPod is not equal to the given one.
   */
  public S hasExecNewPod(ExecNewPodHook execNewPod) {
    // check that actual LifecycleHook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting execNewPod of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ExecNewPodHook actualExecNewPod = actual.getExecNewPod();
    if (!Objects.areEqual(actualExecNewPod, execNewPod)) {
      failWithMessage(assertjErrorMessage, actual, execNewPod, actualExecNewPod);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleHook's failurePolicy is equal to the given one.
   * @param failurePolicy the given failurePolicy to compare the actual LifecycleHook's failurePolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleHook's failurePolicy is not equal to the given one.
   */
  public S hasFailurePolicy(String failurePolicy) {
    // check that actual LifecycleHook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting failurePolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFailurePolicy = actual.getFailurePolicy();
    if (!Objects.areEqual(actualFailurePolicy, failurePolicy)) {
      failWithMessage(assertjErrorMessage, actual, failurePolicy, actualFailurePolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
