package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EndpointAddressFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointAddressFluentImplAssert<S extends AbstractEndpointAddressFluentImplAssert<S, A>, A extends EndpointAddressFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointAddressFluentImplAssert}</code> to make assertions on actual EndpointAddressFluentImpl.
   * @param actual the EndpointAddressFluentImpl we want to make assertions on.
   */
  protected AbstractEndpointAddressFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EndpointAddressFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EndpointAddressFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EndpointAddressFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointAddressFluentImpl's ip is equal to the given one.
   * @param ip the given ip to compare the actual EndpointAddressFluentImpl's ip to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluentImpl's ip is not equal to the given one.
   */
  public S hasIp(String ip) {
    // check that actual EndpointAddressFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting ip of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualIp = actual.getIp();
    if (!Objects.areEqual(actualIp, ip)) {
      failWithMessage(assertjErrorMessage, actual, ip, actualIp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointAddressFluentImpl's targetRef is equal to the given one.
   * @param targetRef the given targetRef to compare the actual EndpointAddressFluentImpl's targetRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluentImpl's targetRef is not equal to the given one.
   */
  public S hasTargetRef(ObjectReference targetRef) {
    // check that actual EndpointAddressFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectReference actualTargetRef = actual.getTargetRef();
    if (!Objects.areEqual(actualTargetRef, targetRef)) {
      failWithMessage(assertjErrorMessage, actual, targetRef, actualTargetRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
