package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStatusAssert<S extends AbstractContainerStatusAssert<S, A>, A extends ContainerStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStatusAssert}</code> to make assertions on actual ContainerStatus.
   * @param actual the ContainerStatus we want to make assertions on.
   */
  protected AbstractContainerStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's containerID is equal to the given one.
   * @param containerID the given containerID to compare the actual ContainerStatus's containerID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's containerID is not equal to the given one.
   */
  public S hasContainerID(String containerID) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting containerID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContainerID = actual.getContainerID();
    if (!Objects.areEqual(actualContainerID, containerID)) {
      failWithMessage(assertjErrorMessage, actual, containerID, actualContainerID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's image is equal to the given one.
   * @param image the given image to compare the actual ContainerStatus's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's imageID is equal to the given one.
   * @param imageID the given imageID to compare the actual ContainerStatus's imageID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's imageID is not equal to the given one.
   */
  public S hasImageID(String imageID) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting imageID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImageID = actual.getImageID();
    if (!Objects.areEqual(actualImageID, imageID)) {
      failWithMessage(assertjErrorMessage, actual, imageID, actualImageID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's lastState is equal to the given one.
   * @param lastState the given lastState to compare the actual ContainerStatus's lastState to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's lastState is not equal to the given one.
   */
  public S hasLastState(ContainerState lastState) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastState of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerState actualLastState = actual.getLastState();
    if (!Objects.areEqual(actualLastState, lastState)) {
      failWithMessage(assertjErrorMessage, actual, lastState, actualLastState);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's name is equal to the given one.
   * @param name the given name to compare the actual ContainerStatus's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's ready is equal to the given one.
   * @param ready the given ready to compare the actual ContainerStatus's ready to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's ready is not equal to the given one.
   */
  public S hasReady(Boolean ready) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting ready of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualReady = actual.getReady();
    if (!Objects.areEqual(actualReady, ready)) {
      failWithMessage(assertjErrorMessage, actual, ready, actualReady);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's restartCount is equal to the given one.
   * @param restartCount the given restartCount to compare the actual ContainerStatus's restartCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's restartCount is not equal to the given one.
   */
  public S hasRestartCount(Integer restartCount) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting restartCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRestartCount = actual.getRestartCount();
    if (!Objects.areEqual(actualRestartCount, restartCount)) {
      failWithMessage(assertjErrorMessage, actual, restartCount, actualRestartCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's state is equal to the given one.
   * @param state the given state to compare the actual ContainerStatus's state to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's state is not equal to the given one.
   */
  public S hasState(ContainerState state) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting state of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerState actualState = actual.getState();
    if (!Objects.areEqual(actualState, state)) {
      failWithMessage(assertjErrorMessage, actual, state, actualState);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
