/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableEventSource;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.EventSourceFluent;
import io.fabric8.kubernetes.api.model.EventSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EventSourceBuilder
extends EventSourceFluentImpl<EventSourceBuilder>
implements VisitableBuilder<EventSource, EventSourceBuilder> {
    EventSourceFluent<?> fluent;

    public EventSourceBuilder() {
        this(new EventSource());
    }

    public EventSourceBuilder(EventSourceFluent<?> fluent) {
        this(fluent, new EventSource());
    }

    public EventSourceBuilder(EventSourceFluent<?> fluent, EventSource instance) {
        this.fluent = fluent;
        fluent.withComponent(instance.getComponent());
        fluent.withHost(instance.getHost());
    }

    public EventSourceBuilder(EventSource instance) {
        this.fluent = this;
        this.withComponent(instance.getComponent());
        this.withHost(instance.getHost());
    }

    public EditableEventSource build() {
        EditableEventSource buildable = new EditableEventSource(this.fluent.getComponent(), this.fluent.getHost());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventSourceBuilder that = (EventSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

