package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HTTPIngressRuleValueFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHTTPIngressRuleValueFluentAssert<S extends AbstractHTTPIngressRuleValueFluentAssert<S, A>, A extends HTTPIngressRuleValueFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHTTPIngressRuleValueFluentAssert}</code> to make assertions on actual HTTPIngressRuleValueFluent.
   * @param actual the HTTPIngressRuleValueFluent we want to make assertions on.
   */
  protected AbstractHTTPIngressRuleValueFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HTTPIngressRuleValueFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual HTTPIngressRuleValueFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPIngressRuleValueFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual HTTPIngressRuleValueFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPIngressRuleValueFluent's paths contains the given HTTPIngressPath elements.
   * @param paths the given elements that should be contained in actual HTTPIngressRuleValueFluent's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual HTTPIngressRuleValueFluent's paths does not contain all given HTTPIngressPath elements.
   */
  public S hasPaths(HTTPIngressPath... paths) {
    // check that actual HTTPIngressRuleValueFluent we want to make assertions on is not null.
    isNotNull();

    // check that given HTTPIngressPath varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPIngressRuleValueFluent's paths contains <b>only<b> the given HTTPIngressPath elements and nothing else in whatever order.
   * @param paths the given elements that should be contained in actual HTTPIngressRuleValueFluent's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual HTTPIngressRuleValueFluent's paths does not contain all given HTTPIngressPath elements.
   */
  public S hasOnlyPaths(HTTPIngressPath... paths) {
    // check that actual HTTPIngressRuleValueFluent we want to make assertions on is not null.
    isNotNull();

    // check that given HTTPIngressPath varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPIngressRuleValueFluent's paths does not contain the given HTTPIngressPath elements.
   *
   * @param paths the given elements that should not be in actual HTTPIngressRuleValueFluent's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual HTTPIngressRuleValueFluent's paths contains any given HTTPIngressPath elements.
   */
  public S doesNotHavePaths(HTTPIngressPath... paths) {
    // check that actual HTTPIngressRuleValueFluent we want to make assertions on is not null.
    isNotNull();

    // check that given HTTPIngressPath varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPIngressRuleValueFluent has no paths.
   * @return this assertion object.
   * @throws AssertionError if the actual HTTPIngressRuleValueFluent's paths is not empty.
   */
  public S hasNoPaths() {
    // check that actual HTTPIngressRuleValueFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have paths but had :\n  <%s>";
    
    // check
    if (actual.getPaths().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPaths());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
