package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EnvVarFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEnvVarFluentImplAssert<S extends AbstractEnvVarFluentImplAssert<S, A>, A extends EnvVarFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEnvVarFluentImplAssert}</code> to make assertions on actual EnvVarFluentImpl.
   * @param actual the EnvVarFluentImpl we want to make assertions on.
   */
  protected AbstractEnvVarFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EnvVarFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EnvVarFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EnvVarFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EnvVarFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EnvVarFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual EnvVarFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EnvVarFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual EnvVarFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EnvVarFluentImpl's value is equal to the given one.
   * @param value the given value to compare the actual EnvVarFluentImpl's value to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EnvVarFluentImpl's value is not equal to the given one.
   */
  public S hasValue(String value) {
    // check that actual EnvVarFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualValue = actual.getValue();
    if (!Objects.areEqual(actualValue, value)) {
      failWithMessage(assertjErrorMessage, actual, value, actualValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EnvVarFluentImpl's valueFrom is equal to the given one.
   * @param valueFrom the given valueFrom to compare the actual EnvVarFluentImpl's valueFrom to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EnvVarFluentImpl's valueFrom is not equal to the given one.
   */
  public S hasValueFrom(EnvVarSource valueFrom) {
    // check that actual EnvVarFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting valueFrom of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EnvVarSource actualValueFrom = actual.getValueFrom();
    if (!Objects.areEqual(actualValueFrom, valueFrom)) {
      failWithMessage(assertjErrorMessage, actual, valueFrom, actualValueFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
