package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodSecurityContextFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSecurityContextFluentAssert<S extends AbstractPodSecurityContextFluentAssert<S, A>, A extends PodSecurityContextFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSecurityContextFluentAssert}</code> to make assertions on actual PodSecurityContextFluent.
   * @param actual the PodSecurityContextFluent we want to make assertions on.
   */
  protected AbstractPodSecurityContextFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodSecurityContextFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodSecurityContextFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContextFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodSecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContextFluent's fsGroup is equal to the given one.
   * @param fsGroup the given fsGroup to compare the actual PodSecurityContextFluent's fsGroup to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContextFluent's fsGroup is not equal to the given one.
   */
  public S hasFsGroup(Long fsGroup) {
    // check that actual PodSecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualFsGroup = actual.getFsGroup();
    if (!Objects.areEqual(actualFsGroup, fsGroup)) {
      failWithMessage(assertjErrorMessage, actual, fsGroup, actualFsGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContextFluent's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual PodSecurityContextFluent's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContextFluent's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(Long runAsUser) {
    // check that actual PodSecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContextFluent's seLinuxOptions is equal to the given one.
   * @param seLinuxOptions the given seLinuxOptions to compare the actual PodSecurityContextFluent's seLinuxOptions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContextFluent's seLinuxOptions is not equal to the given one.
   */
  public S hasSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    // check that actual PodSecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting seLinuxOptions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxOptions actualSeLinuxOptions = actual.getSeLinuxOptions();
    if (!Objects.areEqual(actualSeLinuxOptions, seLinuxOptions)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxOptions, actualSeLinuxOptions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContextFluent's supplementalGroups contains the given Long elements.
   * @param supplementalGroups the given elements that should be contained in actual PodSecurityContextFluent's supplementalGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSecurityContextFluent's supplementalGroups does not contain all given Long elements.
   */
  public S hasSupplementalGroups(Long... supplementalGroups) {
    // check that actual PodSecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (supplementalGroups == null) failWithMessage("Expecting supplementalGroups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSupplementalGroups(), supplementalGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContextFluent's supplementalGroups contains <b>only<b> the given Long elements and nothing else in whatever order.
   * @param supplementalGroups the given elements that should be contained in actual PodSecurityContextFluent's supplementalGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSecurityContextFluent's supplementalGroups does not contain all given Long elements.
   */
  public S hasOnlySupplementalGroups(Long... supplementalGroups) {
    // check that actual PodSecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (supplementalGroups == null) failWithMessage("Expecting supplementalGroups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getSupplementalGroups(), supplementalGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContextFluent's supplementalGroups does not contain the given Long elements.
   *
   * @param supplementalGroups the given elements that should not be in actual PodSecurityContextFluent's supplementalGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSecurityContextFluent's supplementalGroups contains any given Long elements.
   */
  public S doesNotHaveSupplementalGroups(Long... supplementalGroups) {
    // check that actual PodSecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (supplementalGroups == null) failWithMessage("Expecting supplementalGroups parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getSupplementalGroups(), supplementalGroups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSecurityContextFluent has no supplementalGroups.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSecurityContextFluent's supplementalGroups is not empty.
   */
  public S hasNoSupplementalGroups() {
    // check that actual PodSecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have supplementalGroups but had :\n  <%s>";
    
    // check
    if (actual.getSupplementalGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSupplementalGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
