package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DownwardAPIVolumeFileFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDownwardAPIVolumeFileFluentAssert<S extends AbstractDownwardAPIVolumeFileFluentAssert<S, A>, A extends DownwardAPIVolumeFileFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDownwardAPIVolumeFileFluentAssert}</code> to make assertions on actual DownwardAPIVolumeFileFluent.
   * @param actual the DownwardAPIVolumeFileFluent we want to make assertions on.
   */
  protected AbstractDownwardAPIVolumeFileFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DownwardAPIVolumeFileFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DownwardAPIVolumeFileFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DownwardAPIVolumeFileFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DownwardAPIVolumeFileFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DownwardAPIVolumeFileFluent's fieldRef is equal to the given one.
   * @param fieldRef the given fieldRef to compare the actual DownwardAPIVolumeFileFluent's fieldRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DownwardAPIVolumeFileFluent's fieldRef is not equal to the given one.
   */
  public S hasFieldRef(ObjectFieldSelector fieldRef) {
    // check that actual DownwardAPIVolumeFileFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fieldRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectFieldSelector actualFieldRef = actual.getFieldRef();
    if (!Objects.areEqual(actualFieldRef, fieldRef)) {
      failWithMessage(assertjErrorMessage, actual, fieldRef, actualFieldRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DownwardAPIVolumeFileFluent's path is equal to the given one.
   * @param path the given path to compare the actual DownwardAPIVolumeFileFluent's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DownwardAPIVolumeFileFluent's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual DownwardAPIVolumeFileFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
