package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LocalSubjectAccessReview} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLocalSubjectAccessReviewAssert<S extends AbstractLocalSubjectAccessReviewAssert<S, A>, A extends LocalSubjectAccessReview> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLocalSubjectAccessReviewAssert}</code> to make assertions on actual LocalSubjectAccessReview.
   * @param actual the LocalSubjectAccessReview we want to make assertions on.
   */
  protected AbstractLocalSubjectAccessReviewAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LocalSubjectAccessReview's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LocalSubjectAccessReview's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's content is equal to the given one.
   * @param content the given content to compare the actual LocalSubjectAccessReview's content to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LocalSubjectAccessReview's content is not equal to the given one.
   */
  public S hasContent(io.fabric8.kubernetes.api.model.HasMetadata content) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting content of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.HasMetadata actualContent = actual.getContent();
    if (!Objects.areEqual(actualContent, content)) {
      failWithMessage(assertjErrorMessage, actual, content, actualContent);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's groups contains the given String elements.
   * @param groups the given elements that should be contained in actual LocalSubjectAccessReview's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual LocalSubjectAccessReview's groups does not contain all given String elements.
   */
  public S hasGroups(String... groups) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's groups contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param groups the given elements that should be contained in actual LocalSubjectAccessReview's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual LocalSubjectAccessReview's groups does not contain all given String elements.
   */
  public S hasOnlyGroups(String... groups) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's groups does not contain the given String elements.
   *
   * @param groups the given elements that should not be in actual LocalSubjectAccessReview's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual LocalSubjectAccessReview's groups contains any given String elements.
   */
  public S doesNotHaveGroups(String... groups) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview has no groups.
   * @return this assertion object.
   * @throws AssertionError if the actual LocalSubjectAccessReview's groups is not empty.
   */
  public S hasNoGroups() {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have groups but had :\n  <%s>";
    
    // check
    if (actual.getGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual LocalSubjectAccessReview's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual LocalSubjectAccessReview's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LocalSubjectAccessReview's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's resource is equal to the given one.
   * @param resource the given resource to compare the actual LocalSubjectAccessReview's resource to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LocalSubjectAccessReview's resource is not equal to the given one.
   */
  public S hasResource(String resource) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resource of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResource = actual.getResource();
    if (!Objects.areEqual(actualResource, resource)) {
      failWithMessage(assertjErrorMessage, actual, resource, actualResource);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's resourceName is equal to the given one.
   * @param resourceName the given resourceName to compare the actual LocalSubjectAccessReview's resourceName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LocalSubjectAccessReview's resourceName is not equal to the given one.
   */
  public S hasResourceName(String resourceName) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceName = actual.getResourceName();
    if (!Objects.areEqual(actualResourceName, resourceName)) {
      failWithMessage(assertjErrorMessage, actual, resourceName, actualResourceName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's typeMeta is equal to the given one.
   * @param typeMeta the given typeMeta to compare the actual LocalSubjectAccessReview's typeMeta to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LocalSubjectAccessReview's typeMeta is not equal to the given one.
   */
  public S hasTypeMeta(io.fabric8.kubernetes.api.model.TypeMeta typeMeta) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting typeMeta of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.TypeMeta actualTypeMeta = actual.getTypeMeta();
    if (!Objects.areEqual(actualTypeMeta, typeMeta)) {
      failWithMessage(assertjErrorMessage, actual, typeMeta, actualTypeMeta);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's user is equal to the given one.
   * @param user the given user to compare the actual LocalSubjectAccessReview's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LocalSubjectAccessReview's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LocalSubjectAccessReview's verb is equal to the given one.
   * @param verb the given verb to compare the actual LocalSubjectAccessReview's verb to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LocalSubjectAccessReview's verb is not equal to the given one.
   */
  public S hasVerb(String verb) {
    // check that actual LocalSubjectAccessReview we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting verb of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualVerb = actual.getVerb();
    if (!Objects.areEqual(actualVerb, verb)) {
      failWithMessage(assertjErrorMessage, actual, verb, actualVerb);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
