/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableProjectSpec;
import io.fabric8.openshift.api.model.ProjectSpec;
import io.fabric8.openshift.api.model.ProjectSpecFluent;
import io.fabric8.openshift.api.model.ProjectSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ProjectSpecBuilder
extends ProjectSpecFluentImpl<ProjectSpecBuilder>
implements VisitableBuilder<ProjectSpec, ProjectSpecBuilder> {
    ProjectSpecFluent<?> fluent;

    public ProjectSpecBuilder() {
        this(new ProjectSpec());
    }

    public ProjectSpecBuilder(ProjectSpecFluent<?> fluent) {
        this(fluent, new ProjectSpec());
    }

    public ProjectSpecBuilder(ProjectSpecFluent<?> fluent, ProjectSpec instance) {
        this.fluent = fluent;
        fluent.withFinalizers(instance.getFinalizers());
    }

    public ProjectSpecBuilder(ProjectSpec instance) {
        this.fluent = this;
        this.withFinalizers(instance.getFinalizers());
    }

    public EditableProjectSpec build() {
        EditableProjectSpec buildable = new EditableProjectSpec(this.fluent.getFinalizers());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectSpecBuilder that = (ProjectSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

