/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobCondition;
import io.fabric8.kubernetes.api.model.extensions.JobConditionBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobConditionFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobStatus;
import io.fabric8.kubernetes.api.model.extensions.JobStatusFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobStatusFluentImpl<T extends JobStatusFluent<T>>
extends BaseFluent<T>
implements JobStatusFluent<T> {
    Integer active;
    String completionTime;
    List<VisitableBuilder<JobCondition, ?>> conditions = new ArrayList();
    Integer failed;
    String startTime;
    Integer succeeded;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public JobStatusFluentImpl() {
    }

    public JobStatusFluentImpl(JobStatus instance) {
        this.withActive(instance.getActive());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withFailed(instance.getFailed());
        this.withStartTime(instance.getStartTime());
        this.withSucceeded(instance.getSucceeded());
    }

    @Override
    public Integer getActive() {
        return this.active;
    }

    @Override
    public T withActive(Integer active) {
        this.active = active;
        return (T)this;
    }

    @Override
    public String getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public T withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (T)this;
    }

    @Override
    public T addToConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<JobCondition> getConditions() {
        return this.build(this.conditions);
    }

    @Override
    public T withConditions(List<JobCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withConditions(JobCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    @Override
    public JobStatusFluent.ConditionsNested<T> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public JobStatusFluent.ConditionsNested<T> addNewConditionLike(JobCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public Integer getFailed() {
        return this.failed;
    }

    @Override
    public T withFailed(Integer failed) {
        this.failed = failed;
        return (T)this;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public T withStartTime(String startTime) {
        this.startTime = startTime;
        return (T)this;
    }

    @Override
    public Integer getSucceeded() {
        return this.succeeded;
    }

    @Override
    public T withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobStatusFluentImpl that = (JobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.failed != null ? !this.failed.equals(that.failed) : that.failed != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.succeeded != null ? !this.succeeded.equals(that.succeeded) : that.succeeded != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ConditionsNestedImpl<N>
    extends JobConditionFluentImpl<JobStatusFluent.ConditionsNested<N>>
    implements JobStatusFluent.ConditionsNested<N> {
        private final JobConditionBuilder builder;

        ConditionsNestedImpl(JobCondition item) {
            this.builder = new JobConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.builder = new JobConditionBuilder(this);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)JobStatusFluentImpl.this.addToConditions(this.builder.build());
        }
    }
}

