package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ExecAction} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractExecActionAssert<S extends AbstractExecActionAssert<S, A>, A extends ExecAction> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractExecActionAssert}</code> to make assertions on actual ExecAction.
   * @param actual the ExecAction we want to make assertions on.
   */
  protected AbstractExecActionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ExecAction's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ExecAction's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ExecAction's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ExecAction we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecAction's command contains the given String elements.
   * @param command the given elements that should be contained in actual ExecAction's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecAction's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual ExecAction we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecAction's command contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param command the given elements that should be contained in actual ExecAction's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecAction's command does not contain all given String elements.
   */
  public S hasOnlyCommand(String... command) {
    // check that actual ExecAction we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecAction's command does not contain the given String elements.
   *
   * @param command the given elements that should not be in actual ExecAction's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecAction's command contains any given String elements.
   */
  public S doesNotHaveCommand(String... command) {
    // check that actual ExecAction we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecAction has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecAction's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual ExecAction we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
