package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link AuthInfoFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAuthInfoFluentAssert<S extends AbstractAuthInfoFluentAssert<S, A>, A extends AuthInfoFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAuthInfoFluentAssert}</code> to make assertions on actual AuthInfoFluent.
   * @param actual the AuthInfoFluent we want to make assertions on.
   */
  protected AbstractAuthInfoFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual AuthInfoFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual AuthInfoFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfoFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's clientCertificate is equal to the given one.
   * @param clientCertificate the given clientCertificate to compare the actual AuthInfoFluent's clientCertificate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfoFluent's clientCertificate is not equal to the given one.
   */
  public S hasClientCertificate(String clientCertificate) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clientCertificate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClientCertificate = actual.getClientCertificate();
    if (!Objects.areEqual(actualClientCertificate, clientCertificate)) {
      failWithMessage(assertjErrorMessage, actual, clientCertificate, actualClientCertificate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's clientCertificateData is equal to the given one.
   * @param clientCertificateData the given clientCertificateData to compare the actual AuthInfoFluent's clientCertificateData to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfoFluent's clientCertificateData is not equal to the given one.
   */
  public S hasClientCertificateData(String clientCertificateData) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clientCertificateData of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClientCertificateData = actual.getClientCertificateData();
    if (!Objects.areEqual(actualClientCertificateData, clientCertificateData)) {
      failWithMessage(assertjErrorMessage, actual, clientCertificateData, actualClientCertificateData);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's clientKey is equal to the given one.
   * @param clientKey the given clientKey to compare the actual AuthInfoFluent's clientKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfoFluent's clientKey is not equal to the given one.
   */
  public S hasClientKey(String clientKey) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clientKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClientKey = actual.getClientKey();
    if (!Objects.areEqual(actualClientKey, clientKey)) {
      failWithMessage(assertjErrorMessage, actual, clientKey, actualClientKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's clientKeyData is equal to the given one.
   * @param clientKeyData the given clientKeyData to compare the actual AuthInfoFluent's clientKeyData to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfoFluent's clientKeyData is not equal to the given one.
   */
  public S hasClientKeyData(String clientKeyData) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clientKeyData of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualClientKeyData = actual.getClientKeyData();
    if (!Objects.areEqual(actualClientKeyData, clientKeyData)) {
      failWithMessage(assertjErrorMessage, actual, clientKeyData, actualClientKeyData);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual AuthInfoFluent's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfoFluent's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's extensions contains <b>only<b> the given NamedExtension elements and nothing else in whatever order.
   * @param extensions the given elements that should be contained in actual AuthInfoFluent's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfoFluent's extensions does not contain all given NamedExtension elements.
   */
  public S hasOnlyExtensions(NamedExtension... extensions) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's extensions does not contain the given NamedExtension elements.
   *
   * @param extensions the given elements that should not be in actual AuthInfoFluent's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfoFluent's extensions contains any given NamedExtension elements.
   */
  public S doesNotHaveExtensions(NamedExtension... extensions) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual AuthInfoFluent's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual AuthInfoFluent's password is equal to the given one.
   * @param password the given password to compare the actual AuthInfoFluent's password to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfoFluent's password is not equal to the given one.
   */
  public S hasPassword(String password) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting password of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPassword = actual.getPassword();
    if (!Objects.areEqual(actualPassword, password)) {
      failWithMessage(assertjErrorMessage, actual, password, actualPassword);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's token is equal to the given one.
   * @param token the given token to compare the actual AuthInfoFluent's token to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfoFluent's token is not equal to the given one.
   */
  public S hasToken(String token) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting token of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualToken = actual.getToken();
    if (!Objects.areEqual(actualToken, token)) {
      failWithMessage(assertjErrorMessage, actual, token, actualToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AuthInfoFluent's username is equal to the given one.
   * @param username the given username to compare the actual AuthInfoFluent's username to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AuthInfoFluent's username is not equal to the given one.
   */
  public S hasUsername(String username) {
    // check that actual AuthInfoFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting username of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUsername = actual.getUsername();
    if (!Objects.areEqual(actualUsername, username)) {
      failWithMessage(assertjErrorMessage, actual, username, actualUsername);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
