/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Capabilities;
import io.fabric8.kubernetes.api.model.CapabilitiesFluent;
import io.fabric8.kubernetes.api.model.CapabilitiesFluentImpl;
import io.fabric8.kubernetes.api.model.EditableCapabilities;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CapabilitiesBuilder
extends CapabilitiesFluentImpl<CapabilitiesBuilder>
implements VisitableBuilder<Capabilities, CapabilitiesBuilder> {
    CapabilitiesFluent<?> fluent;

    public CapabilitiesBuilder() {
        this(new Capabilities());
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent) {
        this(fluent, new Capabilities());
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent, Capabilities instance) {
        this.fluent = fluent;
        fluent.withAdd(instance.getAdd());
        fluent.withDrop(instance.getDrop());
    }

    public CapabilitiesBuilder(Capabilities instance) {
        this.fluent = this;
        this.withAdd(instance.getAdd());
        this.withDrop(instance.getDrop());
    }

    public EditableCapabilities build() {
        EditableCapabilities buildable = new EditableCapabilities(this.fluent.getAdd(), this.fluent.getDrop());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CapabilitiesBuilder that = (CapabilitiesBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

