package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SubjectAccessReviewResponseFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSubjectAccessReviewResponseFluentAssert<S extends AbstractSubjectAccessReviewResponseFluentAssert<S, A>, A extends SubjectAccessReviewResponseFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSubjectAccessReviewResponseFluentAssert}</code> to make assertions on actual SubjectAccessReviewResponseFluent.
   * @param actual the SubjectAccessReviewResponseFluent we want to make assertions on.
   */
  protected AbstractSubjectAccessReviewResponseFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SubjectAccessReviewResponseFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SubjectAccessReviewResponseFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewResponseFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SubjectAccessReviewResponseFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewResponseFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual SubjectAccessReviewResponseFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewResponseFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(SubjectAccessReviewResponse.ApiVersion apiVersion) {
    // check that actual SubjectAccessReviewResponseFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SubjectAccessReviewResponse.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewResponseFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual SubjectAccessReviewResponseFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewResponseFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual SubjectAccessReviewResponseFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewResponseFluent's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual SubjectAccessReviewResponseFluent's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewResponseFluent's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual SubjectAccessReviewResponseFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewResponseFluent's reason is equal to the given one.
   * @param reason the given reason to compare the actual SubjectAccessReviewResponseFluent's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewResponseFluent's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual SubjectAccessReviewResponseFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
