package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SecurityContext} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecurityContextAssert<S extends AbstractSecurityContextAssert<S, A>, A extends SecurityContext> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecurityContextAssert}</code> to make assertions on actual SecurityContext.
   * @param actual the SecurityContext we want to make assertions on.
   */
  protected AbstractSecurityContextAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SecurityContext's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SecurityContext's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContext's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContext's capabilities is equal to the given one.
   * @param capabilities the given capabilities to compare the actual SecurityContext's capabilities to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContext's capabilities is not equal to the given one.
   */
  public S hasCapabilities(Capabilities capabilities) {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting capabilities of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Capabilities actualCapabilities = actual.getCapabilities();
    if (!Objects.areEqual(actualCapabilities, capabilities)) {
      failWithMessage(assertjErrorMessage, actual, capabilities, actualCapabilities);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContext's privileged is equal to the given one.
   * @param privileged the given privileged to compare the actual SecurityContext's privileged to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContext's privileged is not equal to the given one.
   */
  public S hasPrivileged(Boolean privileged) {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting privileged of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualPrivileged = actual.getPrivileged();
    if (!Objects.areEqual(actualPrivileged, privileged)) {
      failWithMessage(assertjErrorMessage, actual, privileged, actualPrivileged);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContext's runAsNonRoot is equal to the given one.
   * @param runAsNonRoot the given runAsNonRoot to compare the actual SecurityContext's runAsNonRoot to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContext's runAsNonRoot is not equal to the given one.
   */
  public S hasRunAsNonRoot(Boolean runAsNonRoot) {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsNonRoot of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualRunAsNonRoot = actual.getRunAsNonRoot();
    if (!Objects.areEqual(actualRunAsNonRoot, runAsNonRoot)) {
      failWithMessage(assertjErrorMessage, actual, runAsNonRoot, actualRunAsNonRoot);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContext's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual SecurityContext's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContext's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(Long runAsUser) {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContext's seLinuxOptions is equal to the given one.
   * @param seLinuxOptions the given seLinuxOptions to compare the actual SecurityContext's seLinuxOptions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContext's seLinuxOptions is not equal to the given one.
   */
  public S hasSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting seLinuxOptions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxOptions actualSeLinuxOptions = actual.getSeLinuxOptions();
    if (!Objects.areEqual(actualSeLinuxOptions, seLinuxOptions)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxOptions, actualSeLinuxOptions);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
