package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IDRangeFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIDRangeFluentAssert<S extends AbstractIDRangeFluentAssert<S, A>, A extends IDRangeFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIDRangeFluentAssert}</code> to make assertions on actual IDRangeFluent.
   * @param actual the IDRangeFluent we want to make assertions on.
   */
  protected AbstractIDRangeFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IDRangeFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IDRangeFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IDRangeFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IDRangeFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IDRangeFluent's max is equal to the given one.
   * @param max the given max to compare the actual IDRangeFluent's max to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IDRangeFluent's max is not equal to the given one.
   */
  public S hasMax(Long max) {
    // check that actual IDRangeFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting max of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualMax = actual.getMax();
    if (!Objects.areEqual(actualMax, max)) {
      failWithMessage(assertjErrorMessage, actual, max, actualMax);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IDRangeFluent's min is equal to the given one.
   * @param min the given min to compare the actual IDRangeFluent's min to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IDRangeFluent's min is not equal to the given one.
   */
  public S hasMin(Long min) {
    // check that actual IDRangeFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting min of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualMin = actual.getMin();
    if (!Objects.areEqual(actualMin, min)) {
      failWithMessage(assertjErrorMessage, actual, min, actualMin);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
