package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ConfigFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigFluentImplAssert<S extends AbstractConfigFluentImplAssert<S, A>, A extends ConfigFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigFluentImplAssert}</code> to make assertions on actual ConfigFluentImpl.
   * @param actual the ConfigFluentImpl we want to make assertions on.
   */
  protected AbstractConfigFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ConfigFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ConfigFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ConfigFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's clusters contains the given NamedCluster elements.
   * @param clusters the given elements that should be contained in actual ConfigFluentImpl's clusters.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's clusters does not contain all given NamedCluster elements.
   */
  public S hasClusters(NamedCluster... clusters) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedCluster varargs is not null.
    if (clusters == null) failWithMessage("Expecting clusters parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getClusters(), clusters);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's clusters contains <b>only<b> the given NamedCluster elements and nothing else in whatever order.
   * @param clusters the given elements that should be contained in actual ConfigFluentImpl's clusters.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's clusters does not contain all given NamedCluster elements.
   */
  public S hasOnlyClusters(NamedCluster... clusters) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedCluster varargs is not null.
    if (clusters == null) failWithMessage("Expecting clusters parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getClusters(), clusters);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's clusters does not contain the given NamedCluster elements.
   *
   * @param clusters the given elements that should not be in actual ConfigFluentImpl's clusters.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's clusters contains any given NamedCluster elements.
   */
  public S doesNotHaveClusters(NamedCluster... clusters) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedCluster varargs is not null.
    if (clusters == null) failWithMessage("Expecting clusters parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getClusters(), clusters);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl has no clusters.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's clusters is not empty.
   */
  public S hasNoClusters() {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have clusters but had :\n  <%s>";
    
    // check
    if (actual.getClusters().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getClusters());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ConfigFluentImpl's contexts contains the given NamedContext elements.
   * @param contexts the given elements that should be contained in actual ConfigFluentImpl's contexts.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's contexts does not contain all given NamedContext elements.
   */
  public S hasContexts(NamedContext... contexts) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedContext varargs is not null.
    if (contexts == null) failWithMessage("Expecting contexts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getContexts(), contexts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's contexts contains <b>only<b> the given NamedContext elements and nothing else in whatever order.
   * @param contexts the given elements that should be contained in actual ConfigFluentImpl's contexts.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's contexts does not contain all given NamedContext elements.
   */
  public S hasOnlyContexts(NamedContext... contexts) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedContext varargs is not null.
    if (contexts == null) failWithMessage("Expecting contexts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getContexts(), contexts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's contexts does not contain the given NamedContext elements.
   *
   * @param contexts the given elements that should not be in actual ConfigFluentImpl's contexts.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's contexts contains any given NamedContext elements.
   */
  public S doesNotHaveContexts(NamedContext... contexts) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedContext varargs is not null.
    if (contexts == null) failWithMessage("Expecting contexts parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getContexts(), contexts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl has no contexts.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's contexts is not empty.
   */
  public S hasNoContexts() {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have contexts but had :\n  <%s>";
    
    // check
    if (actual.getContexts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getContexts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ConfigFluentImpl's currentContext is equal to the given one.
   * @param currentContext the given currentContext to compare the actual ConfigFluentImpl's currentContext to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigFluentImpl's currentContext is not equal to the given one.
   */
  public S hasCurrentContext(String currentContext) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting currentContext of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCurrentContext = actual.getCurrentContext();
    if (!Objects.areEqual(actualCurrentContext, currentContext)) {
      failWithMessage(assertjErrorMessage, actual, currentContext, actualCurrentContext);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual ConfigFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's extensions contains <b>only<b> the given NamedExtension elements and nothing else in whatever order.
   * @param extensions the given elements that should be contained in actual ConfigFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's extensions does not contain all given NamedExtension elements.
   */
  public S hasOnlyExtensions(NamedExtension... extensions) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's extensions does not contain the given NamedExtension elements.
   *
   * @param extensions the given elements that should not be in actual ConfigFluentImpl's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's extensions contains any given NamedExtension elements.
   */
  public S doesNotHaveExtensions(NamedExtension... extensions) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ConfigFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual ConfigFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's preferences is equal to the given one.
   * @param preferences the given preferences to compare the actual ConfigFluentImpl's preferences to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigFluentImpl's preferences is not equal to the given one.
   */
  public S hasPreferences(Preferences preferences) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting preferences of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Preferences actualPreferences = actual.getPreferences();
    if (!Objects.areEqual(actualPreferences, preferences)) {
      failWithMessage(assertjErrorMessage, actual, preferences, actualPreferences);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's users contains the given NamedAuthInfo elements.
   * @param users the given elements that should be contained in actual ConfigFluentImpl's users.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's users does not contain all given NamedAuthInfo elements.
   */
  public S hasUsers(NamedAuthInfo... users) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedAuthInfo varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's users contains <b>only<b> the given NamedAuthInfo elements and nothing else in whatever order.
   * @param users the given elements that should be contained in actual ConfigFluentImpl's users.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's users does not contain all given NamedAuthInfo elements.
   */
  public S hasOnlyUsers(NamedAuthInfo... users) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedAuthInfo varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl's users does not contain the given NamedAuthInfo elements.
   *
   * @param users the given elements that should not be in actual ConfigFluentImpl's users.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's users contains any given NamedAuthInfo elements.
   */
  public S doesNotHaveUsers(NamedAuthInfo... users) {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedAuthInfo varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigFluentImpl has no users.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigFluentImpl's users is not empty.
   */
  public S hasNoUsers() {
    // check that actual ConfigFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have users but had :\n  <%s>";
    
    // check
    if (actual.getUsers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getUsers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
