/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.CinderVolumeSource;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.FlockerVolumeSource;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeSpecFluentImpl<T extends PersistentVolumeSpecFluent<T>>
extends BaseFluent<T>
implements PersistentVolumeSpecFluent<T> {
    List<String> accessModes = new ArrayList<String>();
    VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;
    Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    VisitableBuilder<CephFSVolumeSource, ?> cephfs;
    VisitableBuilder<CinderVolumeSource, ?> cinder;
    VisitableBuilder<ObjectReference, ?> claimRef;
    VisitableBuilder<FCVolumeSource, ?> fc;
    VisitableBuilder<FlockerVolumeSource, ?> flocker;
    VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;
    VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;
    VisitableBuilder<HostPathVolumeSource, ?> hostPath;
    VisitableBuilder<ISCSIVolumeSource, ?> iscsi;
    VisitableBuilder<NFSVolumeSource, ?> nfs;
    String persistentVolumeReclaimPolicy;
    VisitableBuilder<RBDVolumeSource, ?> rbd;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public PersistentVolumeSpecFluentImpl() {
    }

    public PersistentVolumeSpecFluentImpl(PersistentVolumeSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withCapacity(instance.getCapacity());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withClaimRef(instance.getClaimRef());
        this.withFc(instance.getFc());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
        this.withRbd(instance.getRbd());
    }

    @Override
    public T addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public T withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)this;
    }

    @Override
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? (AWSElasticBlockStoreVolumeSource)this.awsElasticBlockStore.build() : null;
    }

    @Override
    public T withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<T> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    @Override
    public T withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    @Override
    public T addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToCapacity(Map<String, Quantity> map) {
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromCapacity(String key) {
        if (key != null) {
            this.capacity.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromCapacity(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.capacity.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public T withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (T)this;
    }

    @Override
    public CephFSVolumeSource getCephfs() {
        return this.cephfs != null ? (CephFSVolumeSource)this.cephfs.build() : null;
    }

    @Override
    public T withCephfs(CephFSVolumeSource cephfs) {
        if (cephfs != null) {
            this.cephfs = new CephFSVolumeSourceBuilder(cephfs);
            this._visitables.add(this.cephfs);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<T> withNewCephfs() {
        return new CephfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<T> withNewCephfsLike(CephFSVolumeSource item) {
        return new CephfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<T> editCephfs() {
        return this.withNewCephfsLike(this.getCephfs());
    }

    @Override
    public CinderVolumeSource getCinder() {
        return this.cinder != null ? (CinderVolumeSource)this.cinder.build() : null;
    }

    @Override
    public T withCinder(CinderVolumeSource cinder) {
        if (cinder != null) {
            this.cinder = new CinderVolumeSourceBuilder(cinder);
            this._visitables.add(this.cinder);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<T> withNewCinder() {
        return new CinderNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<T> withNewCinderLike(CinderVolumeSource item) {
        return new CinderNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<T> editCinder() {
        return this.withNewCinderLike(this.getCinder());
    }

    @Override
    public T withNewCinder(String fsType, Boolean readOnly, String volumeID) {
        return this.withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    @Override
    public ObjectReference getClaimRef() {
        return this.claimRef != null ? (ObjectReference)this.claimRef.build() : null;
    }

    @Override
    public T withClaimRef(ObjectReference claimRef) {
        if (claimRef != null) {
            this.claimRef = new ObjectReferenceBuilder(claimRef);
            this._visitables.add(this.claimRef);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<T> withNewClaimRef() {
        return new ClaimRefNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<T> withNewClaimRefLike(ObjectReference item) {
        return new ClaimRefNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<T> editClaimRef() {
        return this.withNewClaimRefLike(this.getClaimRef());
    }

    @Override
    public FCVolumeSource getFc() {
        return this.fc != null ? (FCVolumeSource)this.fc.build() : null;
    }

    @Override
    public T withFc(FCVolumeSource fc) {
        if (fc != null) {
            this.fc = new FCVolumeSourceBuilder(fc);
            this._visitables.add(this.fc);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<T> withNewFc() {
        return new FcNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<T> withNewFcLike(FCVolumeSource item) {
        return new FcNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<T> editFc() {
        return this.withNewFcLike(this.getFc());
    }

    @Override
    public FlockerVolumeSource getFlocker() {
        return this.flocker != null ? (FlockerVolumeSource)this.flocker.build() : null;
    }

    @Override
    public T withFlocker(FlockerVolumeSource flocker) {
        if (flocker != null) {
            this.flocker = new FlockerVolumeSourceBuilder(flocker);
            this._visitables.add(this.flocker);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<T> withNewFlocker() {
        return new FlockerNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<T> withNewFlockerLike(FlockerVolumeSource item) {
        return new FlockerNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<T> editFlocker() {
        return this.withNewFlockerLike(this.getFlocker());
    }

    @Override
    public T withNewFlocker(String datasetName) {
        return this.withFlocker(new FlockerVolumeSource(datasetName));
    }

    @Override
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? (GCEPersistentDiskVolumeSource)this.gcePersistentDisk.build() : null;
    }

    @Override
    public T withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<T> withNewGcePersistentDisk() {
        return new GcePersistentDiskNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<T> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<T> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    @Override
    public T withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    @Override
    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? (GlusterfsVolumeSource)this.glusterfs.build() : null;
    }

    @Override
    public T withGlusterfs(GlusterfsVolumeSource glusterfs) {
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<T> withNewGlusterfs() {
        return new GlusterfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<T> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<T> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    @Override
    public T withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    @Override
    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? (HostPathVolumeSource)this.hostPath.build() : null;
    }

    @Override
    public T withHostPath(HostPathVolumeSource hostPath) {
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<T> withNewHostPath() {
        return new HostPathNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<T> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<T> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    @Override
    public T withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    @Override
    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? (ISCSIVolumeSource)this.iscsi.build() : null;
    }

    @Override
    public T withIscsi(ISCSIVolumeSource iscsi) {
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<T> withNewIscsi() {
        return new IscsiNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<T> withNewIscsiLike(ISCSIVolumeSource item) {
        return new IscsiNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<T> editIscsi() {
        return this.withNewIscsiLike(this.getIscsi());
    }

    @Override
    public T withNewIscsi(String fsType, String iqn, Integer lun, Boolean readOnly, String targetPortal) {
        return this.withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }

    @Override
    public NFSVolumeSource getNfs() {
        return this.nfs != null ? (NFSVolumeSource)this.nfs.build() : null;
    }

    @Override
    public T withNfs(NFSVolumeSource nfs) {
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<T> withNewNfs() {
        return new NfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<T> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<T> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    @Override
    public T withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    @Override
    public String getPersistentVolumeReclaimPolicy() {
        return this.persistentVolumeReclaimPolicy;
    }

    @Override
    public T withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
        return (T)this;
    }

    @Override
    public RBDVolumeSource getRbd() {
        return this.rbd != null ? (RBDVolumeSource)this.rbd.build() : null;
    }

    @Override
    public T withRbd(RBDVolumeSource rbd) {
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<T> withNewRbd() {
        return new RbdNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<T> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<T> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.awsElasticBlockStore != null ? !this.awsElasticBlockStore.equals(that.awsElasticBlockStore) : that.awsElasticBlockStore != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.cephfs != null ? !this.cephfs.equals(that.cephfs) : that.cephfs != null) {
            return false;
        }
        if (this.cinder != null ? !this.cinder.equals(that.cinder) : that.cinder != null) {
            return false;
        }
        if (this.claimRef != null ? !this.claimRef.equals(that.claimRef) : that.claimRef != null) {
            return false;
        }
        if (this.fc != null ? !this.fc.equals(that.fc) : that.fc != null) {
            return false;
        }
        if (this.flocker != null ? !this.flocker.equals(that.flocker) : that.flocker != null) {
            return false;
        }
        if (this.gcePersistentDisk != null ? !this.gcePersistentDisk.equals(that.gcePersistentDisk) : that.gcePersistentDisk != null) {
            return false;
        }
        if (this.glusterfs != null ? !this.glusterfs.equals(that.glusterfs) : that.glusterfs != null) {
            return false;
        }
        if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) {
            return false;
        }
        if (this.iscsi != null ? !this.iscsi.equals(that.iscsi) : that.iscsi != null) {
            return false;
        }
        if (this.nfs != null ? !this.nfs.equals(that.nfs) : that.nfs != null) {
            return false;
        }
        if (this.persistentVolumeReclaimPolicy != null ? !this.persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) : that.persistentVolumeReclaimPolicy != null) {
            return false;
        }
        if (this.rbd != null ? !this.rbd.equals(that.rbd) : that.rbd != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RbdNestedImpl<N>
    extends RBDVolumeSourceFluentImpl<PersistentVolumeSpecFluent.RbdNested<N>>
    implements PersistentVolumeSpecFluent.RbdNested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNestedImpl() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        RbdNestedImpl(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withRbd(this.builder.build());
        }

        @Override
        public N endRbd() {
            return this.and();
        }
    }

    public class NfsNestedImpl<N>
    extends NFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.NfsNested<N>>
    implements PersistentVolumeSpecFluent.NfsNested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNestedImpl(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        NfsNestedImpl() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        @Override
        public N endNfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withNfs(this.builder.build());
        }
    }

    public class IscsiNestedImpl<N>
    extends ISCSIVolumeSourceFluentImpl<PersistentVolumeSpecFluent.IscsiNested<N>>
    implements PersistentVolumeSpecFluent.IscsiNested<N> {
        private final ISCSIVolumeSourceBuilder builder;

        IscsiNestedImpl() {
            this.builder = new ISCSIVolumeSourceBuilder(this);
        }

        IscsiNestedImpl(ISCSIVolumeSource item) {
            this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withIscsi(this.builder.build());
        }

        @Override
        public N endIscsi() {
            return this.and();
        }
    }

    public class HostPathNestedImpl<N>
    extends HostPathVolumeSourceFluentImpl<PersistentVolumeSpecFluent.HostPathNested<N>>
    implements PersistentVolumeSpecFluent.HostPathNested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNestedImpl() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        HostPathNestedImpl(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withHostPath(this.builder.build());
        }

        @Override
        public N endHostPath() {
            return this.and();
        }
    }

    public class GlusterfsNestedImpl<N>
    extends GlusterfsVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GlusterfsNested<N>>
    implements PersistentVolumeSpecFluent.GlusterfsNested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNestedImpl() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        GlusterfsNestedImpl(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withGlusterfs(this.builder.build());
        }

        @Override
        public N endGlusterfs() {
            return this.and();
        }
    }

    public class GcePersistentDiskNestedImpl<N>
    extends GCEPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>>
    implements PersistentVolumeSpecFluent.GcePersistentDiskNested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNestedImpl() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        @Override
        public N endGcePersistentDisk() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(this.builder.build());
        }
    }

    public class FlockerNestedImpl<N>
    extends FlockerVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlockerNested<N>>
    implements PersistentVolumeSpecFluent.FlockerNested<N> {
        private final FlockerVolumeSourceBuilder builder;

        FlockerNestedImpl() {
            this.builder = new FlockerVolumeSourceBuilder(this);
        }

        FlockerNestedImpl(FlockerVolumeSource item) {
            this.builder = new FlockerVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFlocker(this.builder.build());
        }

        @Override
        public N endFlocker() {
            return this.and();
        }
    }

    public class FcNestedImpl<N>
    extends FCVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FcNested<N>>
    implements PersistentVolumeSpecFluent.FcNested<N> {
        private final FCVolumeSourceBuilder builder;

        FcNestedImpl() {
            this.builder = new FCVolumeSourceBuilder(this);
        }

        FcNestedImpl(FCVolumeSource item) {
            this.builder = new FCVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFc(this.builder.build());
        }

        @Override
        public N endFc() {
            return this.and();
        }
    }

    public class ClaimRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<PersistentVolumeSpecFluent.ClaimRefNested<N>>
    implements PersistentVolumeSpecFluent.ClaimRefNested<N> {
        private final ObjectReferenceBuilder builder;

        ClaimRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        ClaimRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withClaimRef(this.builder.build());
        }

        @Override
        public N endClaimRef() {
            return this.and();
        }
    }

    public class CinderNestedImpl<N>
    extends CinderVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CinderNested<N>>
    implements PersistentVolumeSpecFluent.CinderNested<N> {
        private final CinderVolumeSourceBuilder builder;

        CinderNestedImpl(CinderVolumeSource item) {
            this.builder = new CinderVolumeSourceBuilder(this, item);
        }

        CinderNestedImpl() {
            this.builder = new CinderVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withCinder(this.builder.build());
        }

        @Override
        public N endCinder() {
            return this.and();
        }
    }

    public class CephfsNestedImpl<N>
    extends CephFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CephfsNested<N>>
    implements PersistentVolumeSpecFluent.CephfsNested<N> {
        private final CephFSVolumeSourceBuilder builder;

        CephfsNestedImpl() {
            this.builder = new CephFSVolumeSourceBuilder(this);
        }

        CephfsNestedImpl(CephFSVolumeSource item) {
            this.builder = new CephFSVolumeSourceBuilder(this, item);
        }

        @Override
        public N endCephfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withCephfs(this.builder.build());
        }
    }

    public class AwsElasticBlockStoreNestedImpl<N>
    extends AWSElasticBlockStoreVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>>
    implements PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNestedImpl() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        @Override
        public N endAwsElasticBlockStore() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(this.builder.build());
        }
    }
}

