package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SecurityContextConstraintsFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecurityContextConstraintsFluentAssert<S extends AbstractSecurityContextConstraintsFluentAssert<S, A>, A extends SecurityContextConstraintsFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecurityContextConstraintsFluentAssert}</code> to make assertions on actual SecurityContextConstraintsFluent.
   * @param actual the SecurityContextConstraintsFluent we want to make assertions on.
   */
  protected AbstractSecurityContextConstraintsFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SecurityContextConstraintsFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's allowedCapabilities contains the given String elements.
   * @param allowedCapabilities the given elements that should be contained in actual SecurityContextConstraintsFluent's allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's allowedCapabilities does not contain all given String elements.
   */
  public S hasAllowedCapabilities(String... allowedCapabilities) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (allowedCapabilities == null) failWithMessage("Expecting allowedCapabilities parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAllowedCapabilities(), allowedCapabilities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's allowedCapabilities contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param allowedCapabilities the given elements that should be contained in actual SecurityContextConstraintsFluent's allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's allowedCapabilities does not contain all given String elements.
   */
  public S hasOnlyAllowedCapabilities(String... allowedCapabilities) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (allowedCapabilities == null) failWithMessage("Expecting allowedCapabilities parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getAllowedCapabilities(), allowedCapabilities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's allowedCapabilities does not contain the given String elements.
   *
   * @param allowedCapabilities the given elements that should not be in actual SecurityContextConstraintsFluent's allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's allowedCapabilities contains any given String elements.
   */
  public S doesNotHaveAllowedCapabilities(String... allowedCapabilities) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (allowedCapabilities == null) failWithMessage("Expecting allowedCapabilities parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getAllowedCapabilities(), allowedCapabilities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent has no allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's allowedCapabilities is not empty.
   */
  public S hasNoAllowedCapabilities() {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allowedCapabilities but had :\n  <%s>";
    
    // check
    if (actual.getAllowedCapabilities().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAllowedCapabilities());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual SecurityContextConstraintsFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(SecurityContextConstraints.ApiVersion apiVersion) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecurityContextConstraints.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's fsGroup is equal to the given one.
   * @param fsGroup the given fsGroup to compare the actual SecurityContextConstraintsFluent's fsGroup to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's fsGroup is not equal to the given one.
   */
  public S hasFsGroup(FSGroupStrategyOptions fsGroup) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    FSGroupStrategyOptions actualFsGroup = actual.getFsGroup();
    if (!Objects.areEqual(actualFsGroup, fsGroup)) {
      failWithMessage(assertjErrorMessage, actual, fsGroup, actualFsGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's groups contains the given String elements.
   * @param groups the given elements that should be contained in actual SecurityContextConstraintsFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's groups does not contain all given String elements.
   */
  public S hasGroups(String... groups) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's groups contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param groups the given elements that should be contained in actual SecurityContextConstraintsFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's groups does not contain all given String elements.
   */
  public S hasOnlyGroups(String... groups) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's groups does not contain the given String elements.
   *
   * @param groups the given elements that should not be in actual SecurityContextConstraintsFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's groups contains any given String elements.
   */
  public S doesNotHaveGroups(String... groups) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent has no groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's groups is not empty.
   */
  public S hasNoGroups() {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have groups but had :\n  <%s>";
    
    // check
    if (actual.getGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual SecurityContextConstraintsFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual SecurityContextConstraintsFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's priority is equal to the given one.
   * @param priority the given priority to compare the actual SecurityContextConstraintsFluent's priority to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's priority is not equal to the given one.
   */
  public S hasPriority(Integer priority) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting priority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPriority = actual.getPriority();
    if (!Objects.areEqual(actualPriority, priority)) {
      failWithMessage(assertjErrorMessage, actual, priority, actualPriority);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual SecurityContextConstraintsFluent's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(RunAsUserStrategyOptions runAsUser) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RunAsUserStrategyOptions actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's seLinuxContext is equal to the given one.
   * @param seLinuxContext the given seLinuxContext to compare the actual SecurityContextConstraintsFluent's seLinuxContext to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's seLinuxContext is not equal to the given one.
   */
  public S hasSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting seLinuxContext of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxContextStrategyOptions actualSeLinuxContext = actual.getSeLinuxContext();
    if (!Objects.areEqual(actualSeLinuxContext, seLinuxContext)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxContext, actualSeLinuxContext);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's supplementalGroups is equal to the given one.
   * @param supplementalGroups the given supplementalGroups to compare the actual SecurityContextConstraintsFluent's supplementalGroups to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluent's supplementalGroups is not equal to the given one.
   */
  public S hasSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting supplementalGroups of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SupplementalGroupsStrategyOptions actualSupplementalGroups = actual.getSupplementalGroups();
    if (!Objects.areEqual(actualSupplementalGroups, supplementalGroups)) {
      failWithMessage(assertjErrorMessage, actual, supplementalGroups, actualSupplementalGroups);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's users contains the given String elements.
   * @param users the given elements that should be contained in actual SecurityContextConstraintsFluent's users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's users does not contain all given String elements.
   */
  public S hasUsers(String... users) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's users contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param users the given elements that should be contained in actual SecurityContextConstraintsFluent's users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's users does not contain all given String elements.
   */
  public S hasOnlyUsers(String... users) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent's users does not contain the given String elements.
   *
   * @param users the given elements that should not be in actual SecurityContextConstraintsFluent's users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's users contains any given String elements.
   */
  public S doesNotHaveUsers(String... users) {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluent has no users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluent's users is not empty.
   */
  public S hasNoUsers() {
    // check that actual SecurityContextConstraintsFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have users but had :\n  <%s>";
    
    // check
    if (actual.getUsers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getUsers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
