/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodSpecFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractPodSpecFluentImplAssert<S extends AbstractPodSpecFluentImplAssert<S, A>, A extends PodSpecFluentImpl>
extends AbstractAssert<S, A> {
    protected AbstractPodSpecFluentImplAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualActiveDeadlineSeconds = ((PodSpecFluentImpl)this.actual).getActiveDeadlineSeconds();
        if (!Objects.areEqual((Object)actualActiveDeadlineSeconds, (Object)activeDeadlineSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, activeDeadlineSeconds, actualActiveDeadlineSeconds});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((PodSpecFluentImpl)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasContainers(Container ... containers) {
        this.isNotNull();
        if (containers == null) {
            this.failWithMessage("Expecting containers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getContainers(), (Object[])containers);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasOnlyContainers(Container ... containers) {
        this.isNotNull();
        if (containers == null) {
            this.failWithMessage("Expecting containers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getContainers(), (Object[])containers);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S doesNotHaveContainers(Container ... containers) {
        this.isNotNull();
        if (containers == null) {
            this.failWithMessage("Expecting containers parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getContainers(), (Object[])containers);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasNoContainers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have containers but had :\n  <%s>";
        if (((PodSpecFluentImpl)this.actual).getContainers().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSpecFluentImpl)this.actual).getContainers()});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasDnsPolicy(String dnsPolicy) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting dnsPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDnsPolicy = ((PodSpecFluentImpl)this.actual).getDnsPolicy();
        if (!Objects.areEqual((Object)actualDnsPolicy, (Object)dnsPolicy)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, dnsPolicy, actualDnsPolicy});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasHost(String host) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualHost = ((PodSpecFluentImpl)this.actual).getHost();
        if (!Objects.areEqual((Object)actualHost, (Object)host)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, host, actualHost});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.isNotNull();
        if (imagePullSecrets == null) {
            this.failWithMessage("Expecting imagePullSecrets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getImagePullSecrets(), (Object[])imagePullSecrets);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasOnlyImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.isNotNull();
        if (imagePullSecrets == null) {
            this.failWithMessage("Expecting imagePullSecrets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getImagePullSecrets(), (Object[])imagePullSecrets);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S doesNotHaveImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.isNotNull();
        if (imagePullSecrets == null) {
            this.failWithMessage("Expecting imagePullSecrets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getImagePullSecrets(), (Object[])imagePullSecrets);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasNoImagePullSecrets() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have imagePullSecrets but had :\n  <%s>";
        if (((PodSpecFluentImpl)this.actual).getImagePullSecrets().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSpecFluentImpl)this.actual).getImagePullSecrets()});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasNodeName(String nodeName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting nodeName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualNodeName = ((PodSpecFluentImpl)this.actual).getNodeName();
        if (!Objects.areEqual((Object)actualNodeName, (Object)nodeName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, nodeName, actualNodeName});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasNodeSelector(Map nodeSelector) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting nodeSelector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualNodeSelector = ((PodSpecFluentImpl)this.actual).getNodeSelector();
        if (!Objects.areEqual(actualNodeSelector, (Object)nodeSelector)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, nodeSelector, actualNodeSelector});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasRestartPolicy(String restartPolicy) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting restartPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRestartPolicy = ((PodSpecFluentImpl)this.actual).getRestartPolicy();
        if (!Objects.areEqual((Object)actualRestartPolicy, (Object)restartPolicy)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, restartPolicy, actualRestartPolicy});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasServiceAccount(String serviceAccount) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting serviceAccount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualServiceAccount = ((PodSpecFluentImpl)this.actual).getServiceAccount();
        if (!Objects.areEqual((Object)actualServiceAccount, (Object)serviceAccount)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, serviceAccount, actualServiceAccount});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasServiceAccountName(String serviceAccountName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting serviceAccountName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualServiceAccountName = ((PodSpecFluentImpl)this.actual).getServiceAccountName();
        if (!Objects.areEqual((Object)actualServiceAccountName, (Object)serviceAccountName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, serviceAccountName, actualServiceAccountName});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting terminationGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualTerminationGracePeriodSeconds = ((PodSpecFluentImpl)this.actual).getTerminationGracePeriodSeconds();
        if (!Objects.areEqual((Object)actualTerminationGracePeriodSeconds, (Object)terminationGracePeriodSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, terminationGracePeriodSeconds, actualTerminationGracePeriodSeconds});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasVolumes(Volume ... volumes) {
        this.isNotNull();
        if (volumes == null) {
            this.failWithMessage("Expecting volumes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getVolumes(), (Object[])volumes);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasOnlyVolumes(Volume ... volumes) {
        this.isNotNull();
        if (volumes == null) {
            this.failWithMessage("Expecting volumes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getVolumes(), (Object[])volumes);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S doesNotHaveVolumes(Volume ... volumes) {
        this.isNotNull();
        if (volumes == null) {
            this.failWithMessage("Expecting volumes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((PodSpecFluentImpl)this.actual).getVolumes(), (Object[])volumes);
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }

    public S hasNoVolumes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have volumes but had :\n  <%s>";
        if (((PodSpecFluentImpl)this.actual).getVolumes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSpecFluentImpl)this.actual).getVolumes()});
        }
        return (S)((Object)((AbstractPodSpecFluentImplAssert)this.myself));
    }
}

