package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ParameterFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractParameterFluentAssert<S extends AbstractParameterFluentAssert<S, A>, A extends ParameterFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractParameterFluentAssert}</code> to make assertions on actual ParameterFluent.
   * @param actual the ParameterFluent we want to make assertions on.
   */
  protected AbstractParameterFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ParameterFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ParameterFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ParameterFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ParameterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterFluent's description is equal to the given one.
   * @param description the given description to compare the actual ParameterFluent's description to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ParameterFluent's description is not equal to the given one.
   */
  public S hasDescription(String description) {
    // check that actual ParameterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting description of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDescription = actual.getDescription();
    if (!Objects.areEqual(actualDescription, description)) {
      failWithMessage(assertjErrorMessage, actual, description, actualDescription);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterFluent's from is equal to the given one.
   * @param from the given from to compare the actual ParameterFluent's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ParameterFluent's from is not equal to the given one.
   */
  public S hasFrom(String from) {
    // check that actual ParameterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterFluent's generate is equal to the given one.
   * @param generate the given generate to compare the actual ParameterFluent's generate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ParameterFluent's generate is not equal to the given one.
   */
  public S hasGenerate(String generate) {
    // check that actual ParameterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualGenerate = actual.getGenerate();
    if (!Objects.areEqual(actualGenerate, generate)) {
      failWithMessage(assertjErrorMessage, actual, generate, actualGenerate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterFluent's name is equal to the given one.
   * @param name the given name to compare the actual ParameterFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ParameterFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ParameterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ParameterFluent's value is equal to the given one.
   * @param value the given value to compare the actual ParameterFluent's value to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ParameterFluent's value is not equal to the given one.
   */
  public S hasValue(String value) {
    // check that actual ParameterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualValue = actual.getValue();
    if (!Objects.areEqual(actualValue, value)) {
      failWithMessage(assertjErrorMessage, actual, value, actualValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
