package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CustomDeploymentStrategyParamsFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomDeploymentStrategyParamsFluentAssert<S extends AbstractCustomDeploymentStrategyParamsFluentAssert<S, A>, A extends CustomDeploymentStrategyParamsFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomDeploymentStrategyParamsFluentAssert}</code> to make assertions on actual CustomDeploymentStrategyParamsFluent.
   * @param actual the CustomDeploymentStrategyParamsFluent we want to make assertions on.
   */
  protected AbstractCustomDeploymentStrategyParamsFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CustomDeploymentStrategyParamsFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomDeploymentStrategyParamsFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent's command contains the given String elements.
   * @param command the given elements that should be contained in actual CustomDeploymentStrategyParamsFluent's command.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParamsFluent's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent's command contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param command the given elements that should be contained in actual CustomDeploymentStrategyParamsFluent's command.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParamsFluent's command does not contain all given String elements.
   */
  public S hasOnlyCommand(String... command) {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent's command does not contain the given String elements.
   *
   * @param command the given elements that should not be in actual CustomDeploymentStrategyParamsFluent's command.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParamsFluent's command contains any given String elements.
   */
  public S doesNotHaveCommand(String... command) {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParamsFluent's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent's environment contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param environment the given elements that should be contained in actual CustomDeploymentStrategyParamsFluent's environment.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParamsFluent's environment does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnvironment(io.fabric8.kubernetes.api.model.EnvVar... environment) {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (environment == null) failWithMessage("Expecting environment parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnvironment(), environment);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent's environment contains <b>only<b> the given io.fabric8.kubernetes.api.model.EnvVar elements and nothing else in whatever order.
   * @param environment the given elements that should be contained in actual CustomDeploymentStrategyParamsFluent's environment.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParamsFluent's environment does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasOnlyEnvironment(io.fabric8.kubernetes.api.model.EnvVar... environment) {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (environment == null) failWithMessage("Expecting environment parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getEnvironment(), environment);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent's environment does not contain the given io.fabric8.kubernetes.api.model.EnvVar elements.
   *
   * @param environment the given elements that should not be in actual CustomDeploymentStrategyParamsFluent's environment.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParamsFluent's environment contains any given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S doesNotHaveEnvironment(io.fabric8.kubernetes.api.model.EnvVar... environment) {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (environment == null) failWithMessage("Expecting environment parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getEnvironment(), environment);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent has no environment.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomDeploymentStrategyParamsFluent's environment is not empty.
   */
  public S hasNoEnvironment() {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have environment but had :\n  <%s>";
    
    // check
    if (actual.getEnvironment().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnvironment());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CustomDeploymentStrategyParamsFluent's image is equal to the given one.
   * @param image the given image to compare the actual CustomDeploymentStrategyParamsFluent's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomDeploymentStrategyParamsFluent's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual CustomDeploymentStrategyParamsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
