package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildConfigSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildConfigSpecFluentAssert<S extends AbstractBuildConfigSpecFluentAssert<S, A>, A extends BuildConfigSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildConfigSpecFluentAssert}</code> to make assertions on actual BuildConfigSpecFluent.
   * @param actual the BuildConfigSpecFluent we want to make assertions on.
   */
  protected AbstractBuildConfigSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildConfigSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's output is equal to the given one.
   * @param output the given output to compare the actual BuildConfigSpecFluent's output to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigSpecFluent's output is not equal to the given one.
   */
  public S hasOutput(BuildOutput output) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting output of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildOutput actualOutput = actual.getOutput();
    if (!Objects.areEqual(actualOutput, output)) {
      failWithMessage(assertjErrorMessage, actual, output, actualOutput);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's resources is equal to the given one.
   * @param resources the given resources to compare the actual BuildConfigSpecFluent's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigSpecFluent's resources is not equal to the given one.
   */
  public S hasResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ResourceRequirements actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's revision is equal to the given one.
   * @param revision the given revision to compare the actual BuildConfigSpecFluent's revision to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigSpecFluent's revision is not equal to the given one.
   */
  public S hasRevision(SourceRevision revision) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting revision of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SourceRevision actualRevision = actual.getRevision();
    if (!Objects.areEqual(actualRevision, revision)) {
      failWithMessage(assertjErrorMessage, actual, revision, actualRevision);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's serviceAccount is equal to the given one.
   * @param serviceAccount the given serviceAccount to compare the actual BuildConfigSpecFluent's serviceAccount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigSpecFluent's serviceAccount is not equal to the given one.
   */
  public S hasServiceAccount(String serviceAccount) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting serviceAccount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServiceAccount = actual.getServiceAccount();
    if (!Objects.areEqual(actualServiceAccount, serviceAccount)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccount, actualServiceAccount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's source is equal to the given one.
   * @param source the given source to compare the actual BuildConfigSpecFluent's source to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigSpecFluent's source is not equal to the given one.
   */
  public S hasSource(BuildSource source) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting source of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildSource actualSource = actual.getSource();
    if (!Objects.areEqual(actualSource, source)) {
      failWithMessage(assertjErrorMessage, actual, source, actualSource);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's strategy is equal to the given one.
   * @param strategy the given strategy to compare the actual BuildConfigSpecFluent's strategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigSpecFluent's strategy is not equal to the given one.
   */
  public S hasStrategy(BuildStrategy strategy) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting strategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildStrategy actualStrategy = actual.getStrategy();
    if (!Objects.areEqual(actualStrategy, strategy)) {
      failWithMessage(assertjErrorMessage, actual, strategy, actualStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's triggers contains the given BuildTriggerPolicy elements.
   * @param triggers the given elements that should be contained in actual BuildConfigSpecFluent's triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildConfigSpecFluent's triggers does not contain all given BuildTriggerPolicy elements.
   */
  public S hasTriggers(BuildTriggerPolicy... triggers) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given BuildTriggerPolicy varargs is not null.
    if (triggers == null) failWithMessage("Expecting triggers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTriggers(), triggers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's triggers contains <b>only<b> the given BuildTriggerPolicy elements and nothing else in whatever order.
   * @param triggers the given elements that should be contained in actual BuildConfigSpecFluent's triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildConfigSpecFluent's triggers does not contain all given BuildTriggerPolicy elements.
   */
  public S hasOnlyTriggers(BuildTriggerPolicy... triggers) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given BuildTriggerPolicy varargs is not null.
    if (triggers == null) failWithMessage("Expecting triggers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getTriggers(), triggers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent's triggers does not contain the given BuildTriggerPolicy elements.
   *
   * @param triggers the given elements that should not be in actual BuildConfigSpecFluent's triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildConfigSpecFluent's triggers contains any given BuildTriggerPolicy elements.
   */
  public S doesNotHaveTriggers(BuildTriggerPolicy... triggers) {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given BuildTriggerPolicy varargs is not null.
    if (triggers == null) failWithMessage("Expecting triggers parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getTriggers(), triggers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigSpecFluent has no triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildConfigSpecFluent's triggers is not empty.
   */
  public S hasNoTriggers() {
    // check that actual BuildConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have triggers but had :\n  <%s>";
    
    // check
    if (actual.getTriggers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTriggers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
