package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link StatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatusFluentImplAssert<S extends AbstractStatusFluentImplAssert<S, A>, A extends StatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatusFluentImplAssert}</code> to make assertions on actual StatusFluentImpl.
   * @param actual the StatusFluentImpl we want to make assertions on.
   */
  protected AbstractStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual StatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual StatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual StatusFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Status.ApiVersion apiVersion) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Status.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusFluentImpl's code is equal to the given one.
   * @param code the given code to compare the actual StatusFluentImpl's code to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's code is not equal to the given one.
   */
  public S hasCode(Integer code) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting code of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCode = actual.getCode();
    if (!Objects.areEqual(actualCode, code)) {
      failWithMessage(assertjErrorMessage, actual, code, actualCode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusFluentImpl's details is equal to the given one.
   * @param details the given details to compare the actual StatusFluentImpl's details to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's details is not equal to the given one.
   */
  public S hasDetails(StatusDetails details) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting details of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    StatusDetails actualDetails = actual.getDetails();
    if (!Objects.areEqual(actualDetails, details)) {
      failWithMessage(assertjErrorMessage, actual, details, actualDetails);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual StatusFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusFluentImpl's message is equal to the given one.
   * @param message the given message to compare the actual StatusFluentImpl's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual StatusFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(ListMeta metadata) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ListMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusFluentImpl's reason is equal to the given one.
   * @param reason the given reason to compare the actual StatusFluentImpl's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusFluentImpl's status is equal to the given one.
   * @param status the given status to compare the actual StatusFluentImpl's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusFluentImpl's status is not equal to the given one.
   */
  public S hasStatus(String status) {
    // check that actual StatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
