package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodConditionFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodConditionFluentAssert<S extends AbstractPodConditionFluentAssert<S, A>, A extends PodConditionFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodConditionFluentAssert}</code> to make assertions on actual PodConditionFluent.
   * @param actual the PodConditionFluent we want to make assertions on.
   */
  protected AbstractPodConditionFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodConditionFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodConditionFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodConditionFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodConditionFluent's status is equal to the given one.
   * @param status the given status to compare the actual PodConditionFluent's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodConditionFluent's status is not equal to the given one.
   */
  public S hasStatus(String status) {
    // check that actual PodConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodConditionFluent's type is equal to the given one.
   * @param type the given type to compare the actual PodConditionFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodConditionFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual PodConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
