package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeStatusAssert<S extends AbstractNodeStatusAssert<S, A>, A extends NodeStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeStatusAssert}</code> to make assertions on actual NodeStatus.
   * @param actual the NodeStatus we want to make assertions on.
   */
  protected AbstractNodeStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus's addresses contains the given NodeAddress elements.
   * @param addresses the given elements that should be contained in actual NodeStatus's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's addresses does not contain all given NodeAddress elements.
   */
  public S hasAddresses(NodeAddress... addresses) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // check that given NodeAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus's addresses contains <b>only<b> the given NodeAddress elements and nothing else in whatever order.
   * @param addresses the given elements that should be contained in actual NodeStatus's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's addresses does not contain all given NodeAddress elements.
   */
  public S hasOnlyAddresses(NodeAddress... addresses) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // check that given NodeAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus's addresses does not contain the given NodeAddress elements.
   *
   * @param addresses the given elements that should not be in actual NodeStatus's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's addresses contains any given NodeAddress elements.
   */
  public S doesNotHaveAddresses(NodeAddress... addresses) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // check that given NodeAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus has no addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's addresses is not empty.
   */
  public S hasNoAddresses() {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have addresses but had :\n  <%s>";
    
    // check
    if (actual.getAddresses().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAddresses());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NodeStatus's capacity is equal to the given one.
   * @param capacity the given capacity to compare the actual NodeStatus's capacity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatus's capacity is not equal to the given one.
   */
  public S hasCapacity(java.util.Map capacity) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting capacity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualCapacity = actual.getCapacity();
    if (!Objects.areEqual(actualCapacity, capacity)) {
      failWithMessage(assertjErrorMessage, actual, capacity, actualCapacity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus's conditions contains the given NodeCondition elements.
   * @param conditions the given elements that should be contained in actual NodeStatus's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's conditions does not contain all given NodeCondition elements.
   */
  public S hasConditions(NodeCondition... conditions) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // check that given NodeCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus's conditions contains <b>only<b> the given NodeCondition elements and nothing else in whatever order.
   * @param conditions the given elements that should be contained in actual NodeStatus's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's conditions does not contain all given NodeCondition elements.
   */
  public S hasOnlyConditions(NodeCondition... conditions) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // check that given NodeCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus's conditions does not contain the given NodeCondition elements.
   *
   * @param conditions the given elements that should not be in actual NodeStatus's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's conditions contains any given NodeCondition elements.
   */
  public S doesNotHaveConditions(NodeCondition... conditions) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // check that given NodeCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NodeStatus's nodeInfo is equal to the given one.
   * @param nodeInfo the given nodeInfo to compare the actual NodeStatus's nodeInfo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatus's nodeInfo is not equal to the given one.
   */
  public S hasNodeInfo(NodeSystemInfo nodeInfo) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting nodeInfo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeSystemInfo actualNodeInfo = actual.getNodeInfo();
    if (!Objects.areEqual(actualNodeInfo, nodeInfo)) {
      failWithMessage(assertjErrorMessage, actual, nodeInfo, actualNodeInfo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus's phase is equal to the given one.
   * @param phase the given phase to compare the actual NodeStatus's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatus's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
