package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GlusterfsVolumeSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGlusterfsVolumeSourceFluentAssert<S extends AbstractGlusterfsVolumeSourceFluentAssert<S, A>, A extends GlusterfsVolumeSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGlusterfsVolumeSourceFluentAssert}</code> to make assertions on actual GlusterfsVolumeSourceFluent.
   * @param actual the GlusterfsVolumeSourceFluent we want to make assertions on.
   */
  protected AbstractGlusterfsVolumeSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GlusterfsVolumeSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GlusterfsVolumeSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GlusterfsVolumeSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GlusterfsVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GlusterfsVolumeSourceFluent's endpoints is equal to the given one.
   * @param endpoints the given endpoints to compare the actual GlusterfsVolumeSourceFluent's endpoints to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GlusterfsVolumeSourceFluent's endpoints is not equal to the given one.
   */
  public S hasEndpoints(String endpoints) {
    // check that actual GlusterfsVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting endpoints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualEndpoints = actual.getEndpoints();
    if (!Objects.areEqual(actualEndpoints, endpoints)) {
      failWithMessage(assertjErrorMessage, actual, endpoints, actualEndpoints);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GlusterfsVolumeSourceFluent's path is equal to the given one.
   * @param path the given path to compare the actual GlusterfsVolumeSourceFluent's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GlusterfsVolumeSourceFluent's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual GlusterfsVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
