package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EndpointSubset} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointSubsetAssert<S extends AbstractEndpointSubsetAssert<S, A>, A extends EndpointSubset> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointSubsetAssert}</code> to make assertions on actual EndpointSubset.
   * @param actual the EndpointSubset we want to make assertions on.
   */
  protected AbstractEndpointSubsetAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EndpointSubset's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EndpointSubset's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointSubset's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointSubset's addresses contains the given EndpointAddress elements.
   * @param addresses the given elements that should be contained in actual EndpointSubset's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointSubset's addresses does not contain all given EndpointAddress elements.
   */
  public S hasAddresses(EndpointAddress... addresses) {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointSubset's addresses contains <b>only<b> the given EndpointAddress elements and nothing else in whatever order.
   * @param addresses the given elements that should be contained in actual EndpointSubset's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointSubset's addresses does not contain all given EndpointAddress elements.
   */
  public S hasOnlyAddresses(EndpointAddress... addresses) {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointSubset's addresses does not contain the given EndpointAddress elements.
   *
   * @param addresses the given elements that should not be in actual EndpointSubset's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointSubset's addresses contains any given EndpointAddress elements.
   */
  public S doesNotHaveAddresses(EndpointAddress... addresses) {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointSubset has no addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointSubset's addresses is not empty.
   */
  public S hasNoAddresses() {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have addresses but had :\n  <%s>";
    
    // check
    if (actual.getAddresses().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAddresses());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual EndpointSubset's ports contains the given EndpointPort elements.
   * @param ports the given elements that should be contained in actual EndpointSubset's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointSubset's ports does not contain all given EndpointPort elements.
   */
  public S hasPorts(EndpointPort... ports) {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointPort varargs is not null.
    if (ports == null) failWithMessage("Expecting ports parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointSubset's ports contains <b>only<b> the given EndpointPort elements and nothing else in whatever order.
   * @param ports the given elements that should be contained in actual EndpointSubset's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointSubset's ports does not contain all given EndpointPort elements.
   */
  public S hasOnlyPorts(EndpointPort... ports) {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointPort varargs is not null.
    if (ports == null) failWithMessage("Expecting ports parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointSubset's ports does not contain the given EndpointPort elements.
   *
   * @param ports the given elements that should not be in actual EndpointSubset's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointSubset's ports contains any given EndpointPort elements.
   */
  public S doesNotHavePorts(EndpointPort... ports) {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointPort varargs is not null.
    if (ports == null) failWithMessage("Expecting ports parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointSubset has no ports.
   * @return this assertion object.
   * @throws AssertionError if the actual EndpointSubset's ports is not empty.
   */
  public S hasNoPorts() {
    // check that actual EndpointSubset we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have ports but had :\n  <%s>";
    
    // check
    if (actual.getPorts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPorts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
