package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ClusterFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClusterFluentAssert<S extends AbstractClusterFluentAssert<S, A>, A extends ClusterFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClusterFluentAssert}</code> to make assertions on actual ClusterFluent.
   * @param actual the ClusterFluent we want to make assertions on.
   */
  protected AbstractClusterFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ClusterFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ClusterFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ClusterFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterFluent's certificateAuthority is equal to the given one.
   * @param certificateAuthority the given certificateAuthority to compare the actual ClusterFluent's certificateAuthority to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterFluent's certificateAuthority is not equal to the given one.
   */
  public S hasCertificateAuthority(String certificateAuthority) {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting certificateAuthority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCertificateAuthority = actual.getCertificateAuthority();
    if (!Objects.areEqual(actualCertificateAuthority, certificateAuthority)) {
      failWithMessage(assertjErrorMessage, actual, certificateAuthority, actualCertificateAuthority);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterFluent's certificateAuthorityData is equal to the given one.
   * @param certificateAuthorityData the given certificateAuthorityData to compare the actual ClusterFluent's certificateAuthorityData to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterFluent's certificateAuthorityData is not equal to the given one.
   */
  public S hasCertificateAuthorityData(String certificateAuthorityData) {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting certificateAuthorityData of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCertificateAuthorityData = actual.getCertificateAuthorityData();
    if (!Objects.areEqual(actualCertificateAuthorityData, certificateAuthorityData)) {
      failWithMessage(assertjErrorMessage, actual, certificateAuthorityData, actualCertificateAuthorityData);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterFluent's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual ClusterFluent's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterFluent's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterFluent's extensions contains <b>only<b> the given NamedExtension elements and nothing else in whatever order.
   * @param extensions the given elements that should be contained in actual ClusterFluent's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterFluent's extensions does not contain all given NamedExtension elements.
   */
  public S hasOnlyExtensions(NamedExtension... extensions) {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterFluent's extensions does not contain the given NamedExtension elements.
   *
   * @param extensions the given elements that should not be in actual ClusterFluent's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterFluent's extensions contains any given NamedExtension elements.
   */
  public S doesNotHaveExtensions(NamedExtension... extensions) {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) failWithMessage("Expecting extensions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterFluent has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterFluent's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ClusterFluent's server is equal to the given one.
   * @param server the given server to compare the actual ClusterFluent's server to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterFluent's server is not equal to the given one.
   */
  public S hasServer(String server) {
    // check that actual ClusterFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting server of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServer = actual.getServer();
    if (!Objects.areEqual(actualServer, server)) {
      failWithMessage(assertjErrorMessage, actual, server, actualServer);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
