package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link VolumeMountFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeMountFluentImplAssert<S extends AbstractVolumeMountFluentImplAssert<S, A>, A extends VolumeMountFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeMountFluentImplAssert}</code> to make assertions on actual VolumeMountFluentImpl.
   * @param actual the VolumeMountFluentImpl we want to make assertions on.
   */
  protected AbstractVolumeMountFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual VolumeMountFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual VolumeMountFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeMountFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual VolumeMountFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeMountFluentImpl's mountPath is equal to the given one.
   * @param mountPath the given mountPath to compare the actual VolumeMountFluentImpl's mountPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeMountFluentImpl's mountPath is not equal to the given one.
   */
  public S hasMountPath(String mountPath) {
    // check that actual VolumeMountFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected mountPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMountPath = actual.getMountPath();
    if (!Objects.areEqual(actualMountPath, mountPath)) {
      failWithMessage(assertjErrorMessage, actual, mountPath, actualMountPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeMountFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual VolumeMountFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeMountFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual VolumeMountFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
