package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SecurityContextConstraintsFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecurityContextConstraintsFluentImplAssert<S extends AbstractSecurityContextConstraintsFluentImplAssert<S, A>, A extends SecurityContextConstraintsFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecurityContextConstraintsFluentImplAssert}</code> to make assertions on actual SecurityContextConstraintsFluentImpl.
   * @param actual the SecurityContextConstraintsFluentImpl we want to make assertions on.
   */
  protected AbstractSecurityContextConstraintsFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SecurityContextConstraintsFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's allowedCapabilities contains the given String elements.
   * @param allowedCapabilities the given elements that should be contained in actual SecurityContextConstraintsFluentImpl's allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluentImpl's allowedCapabilities does not contain all given String elements.
   */
  public S hasAllowedCapabilities(String... allowedCapabilities) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (allowedCapabilities == null) throw new AssertionError("Expecting allowedCapabilities parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAllowedCapabilities(), allowedCapabilities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl has no allowedCapabilities.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluentImpl's allowedCapabilities is not empty.
   */
  public S hasNoAllowedCapabilities() {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have allowedCapabilities but had :\n  <%s>";
    
    // check
    if (actual.getAllowedCapabilities().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAllowedCapabilities());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual SecurityContextConstraintsFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(SecurityContextConstraints.ApiVersion apiVersion) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecurityContextConstraints.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's groups contains the given String elements.
   * @param groups the given elements that should be contained in actual SecurityContextConstraintsFluentImpl's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluentImpl's groups does not contain all given String elements.
   */
  public S hasGroups(String... groups) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) throw new AssertionError("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl has no groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluentImpl's groups is not empty.
   */
  public S hasNoGroups() {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have groups but had :\n  <%s>";
    
    // check
    if (actual.getGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual SecurityContextConstraintsFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual SecurityContextConstraintsFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual SecurityContextConstraintsFluentImpl's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluentImpl's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(RunAsUserStrategyOptions runAsUser) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RunAsUserStrategyOptions actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's seLinuxContext is equal to the given one.
   * @param seLinuxContext the given seLinuxContext to compare the actual SecurityContextConstraintsFluentImpl's seLinuxContext to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraintsFluentImpl's seLinuxContext is not equal to the given one.
   */
  public S hasSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected seLinuxContext of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxContextStrategyOptions actualSeLinuxContext = actual.getSeLinuxContext();
    if (!Objects.areEqual(actualSeLinuxContext, seLinuxContext)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxContext, actualSeLinuxContext);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl's users contains the given String elements.
   * @param users the given elements that should be contained in actual SecurityContextConstraintsFluentImpl's users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluentImpl's users does not contain all given String elements.
   */
  public S hasUsers(String... users) {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) throw new AssertionError("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextConstraintsFluentImpl has no users.
   * @return this assertion object.
   * @throws AssertionError if the actual SecurityContextConstraintsFluentImpl's users is not empty.
   */
  public S hasNoUsers() {
    // check that actual SecurityContextConstraintsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have users but had :\n  <%s>";
    
    // check
    if (actual.getUsers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getUsers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
