package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamespaceListFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamespaceListFluentImplAssert<S extends AbstractNamespaceListFluentImplAssert<S, A>, A extends NamespaceListFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamespaceListFluentImplAssert}</code> to make assertions on actual NamespaceListFluentImpl.
   * @param actual the NamespaceListFluentImpl we want to make assertions on.
   */
  protected AbstractNamespaceListFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamespaceListFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamespaceListFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamespaceListFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamespaceListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamespaceListFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual NamespaceListFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamespaceListFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(NamespaceList.ApiVersion apiVersion) {
    // check that actual NamespaceListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NamespaceList.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamespaceListFluentImpl's items contains the given Namespace elements.
   * @param items the given elements that should be contained in actual NamespaceListFluentImpl's items.
   * @return this assertion object.
   * @throws AssertionError if the actual NamespaceListFluentImpl's items does not contain all given Namespace elements.
   */
  public S hasItems(Namespace... items) {
    // check that actual NamespaceListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given Namespace varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamespaceListFluentImpl has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual NamespaceListFluentImpl's items is not empty.
   */
  public S hasNoItems() {
    // check that actual NamespaceListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NamespaceListFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual NamespaceListFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamespaceListFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual NamespaceListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamespaceListFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual NamespaceListFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamespaceListFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(ListMeta metadata) {
    // check that actual NamespaceListFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ListMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
