package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IdentityFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIdentityFluentImplAssert<S extends AbstractIdentityFluentImplAssert<S, A>, A extends IdentityFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIdentityFluentImplAssert}</code> to make assertions on actual IdentityFluentImpl.
   * @param actual the IdentityFluentImpl we want to make assertions on.
   */
  protected AbstractIdentityFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IdentityFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IdentityFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IdentityFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual IdentityFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Identity.ApiVersion apiVersion) {
    // check that actual IdentityFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Identity.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluentImpl's extra is equal to the given one.
   * @param extra the given extra to compare the actual IdentityFluentImpl's extra to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluentImpl's extra is not equal to the given one.
   */
  public S hasExtra(java.util.Map extra) {
    // check that actual IdentityFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected extra of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualExtra = actual.getExtra();
    if (!Objects.areEqual(actualExtra, extra)) {
      failWithMessage(assertjErrorMessage, actual, extra, actualExtra);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual IdentityFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual IdentityFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual IdentityFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual IdentityFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluentImpl's providerName is equal to the given one.
   * @param providerName the given providerName to compare the actual IdentityFluentImpl's providerName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluentImpl's providerName is not equal to the given one.
   */
  public S hasProviderName(String providerName) {
    // check that actual IdentityFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected providerName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProviderName = actual.getProviderName();
    if (!Objects.areEqual(actualProviderName, providerName)) {
      failWithMessage(assertjErrorMessage, actual, providerName, actualProviderName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluentImpl's providerUserName is equal to the given one.
   * @param providerUserName the given providerUserName to compare the actual IdentityFluentImpl's providerUserName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluentImpl's providerUserName is not equal to the given one.
   */
  public S hasProviderUserName(String providerUserName) {
    // check that actual IdentityFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected providerUserName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProviderUserName = actual.getProviderUserName();
    if (!Objects.areEqual(actualProviderUserName, providerUserName)) {
      failWithMessage(assertjErrorMessage, actual, providerUserName, actualProviderUserName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluentImpl's user is equal to the given one.
   * @param user the given user to compare the actual IdentityFluentImpl's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluentImpl's user is not equal to the given one.
   */
  public S hasUser(io.fabric8.kubernetes.api.model.ObjectReference user) {
    // check that actual IdentityFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
