package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentConfigSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentConfigSpecFluentImplAssert<S extends AbstractDeploymentConfigSpecFluentImplAssert<S, A>, A extends DeploymentConfigSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentConfigSpecFluentImplAssert}</code> to make assertions on actual DeploymentConfigSpecFluentImpl.
   * @param actual the DeploymentConfigSpecFluentImpl we want to make assertions on.
   */
  protected AbstractDeploymentConfigSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentConfigSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentConfigSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluentImpl's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual DeploymentConfigSpecFluentImpl's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluentImpl's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual DeploymentConfigSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluentImpl's selector is equal to the given one.
   * @param selector the given selector to compare the actual DeploymentConfigSpecFluentImpl's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluentImpl's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual DeploymentConfigSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluentImpl's strategy is equal to the given one.
   * @param strategy the given strategy to compare the actual DeploymentConfigSpecFluentImpl's strategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluentImpl's strategy is not equal to the given one.
   */
  public S hasStrategy(DeploymentStrategy strategy) {
    // check that actual DeploymentConfigSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected strategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeploymentStrategy actualStrategy = actual.getStrategy();
    if (!Objects.areEqual(actualStrategy, strategy)) {
      failWithMessage(assertjErrorMessage, actual, strategy, actualStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluentImpl's template is equal to the given one.
   * @param template the given template to compare the actual DeploymentConfigSpecFluentImpl's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluentImpl's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    // check that actual DeploymentConfigSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluentImpl's triggers contains the given DeploymentTriggerPolicy elements.
   * @param triggers the given elements that should be contained in actual DeploymentConfigSpecFluentImpl's triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentConfigSpecFluentImpl's triggers does not contain all given DeploymentTriggerPolicy elements.
   */
  public S hasTriggers(DeploymentTriggerPolicy... triggers) {
    // check that actual DeploymentConfigSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given DeploymentTriggerPolicy varargs is not null.
    if (triggers == null) throw new AssertionError("Expecting triggers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTriggers(), triggers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluentImpl has no triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentConfigSpecFluentImpl's triggers is not empty.
   */
  public S hasNoTriggers() {
    // check that actual DeploymentConfigSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have triggers but had :\n  <%s>";
    
    // check
    if (actual.getTriggers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTriggers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
